/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.objectfilter.impl.syntax.parser.AggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.CacheValueAggregationPropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;

public final class QueryAnalyzer<TypeMetadata> {
    private final ObjectPropertyHelper<TypeMetadata> propertyHelper;

    public QueryAnalyzer(ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public boolean fullIndexingAggregation(IckleParsingResult<TypeMetadata> parsingResult) {
        PropertyPath groupBy;
        Object[] groupByPath;
        BooleanExpr havingClause = parsingResult.getHavingClause();
        if (havingClause != null) {
            return false;
        }
        PropertyPath[] groupBys = parsingResult.getGroupBy();
        if (groupBys == null || groupBys.length != 1) {
            return false;
        }
        IndexedFieldProvider.FieldIndexingMetadata metadata = this.propertyHelper.getIndexedFieldProvider().get(parsingResult.getTargetEntityMetadata());
        if (!metadata.isAggregable((String[])(groupByPath = (groupBy = groupBys[0]).asArrayPath()))) {
            return false;
        }
        PropertyPath[] projectedPaths = parsingResult.getProjectedPaths();
        AggregationPropertyPath aggregation = null;
        PropertyPath projection = null;
        for (PropertyPath projectedPath : projectedPaths) {
            if (projectedPath instanceof AggregationPropertyPath) {
                if (aggregation != null) {
                    return false;
                }
                aggregation = (AggregationPropertyPath)projectedPath;
                if (!AggregationFunction.COUNT.equals((Object)aggregation.getAggregationFunction())) {
                    return false;
                }
                boolean aggregationTargetsAProperty = this.propertyHelper.hasProperty(parsingResult.getTargetEntityMetadata(), aggregation.asArrayPath());
                if (!aggregationTargetsAProperty || aggregation instanceof CacheValueAggregationPropertyPath || metadata.isSearchable(aggregation.asArrayPath())) continue;
                return false;
            }
            projection = projectedPath;
            if (Arrays.equals(groupByPath, projection.asArrayPath())) continue;
            return false;
        }
        if (aggregation == null || projection == null) {
            return false;
        }
        SortField[] sortFields = parsingResult.getSortFields();
        if (sortFields == null || sortFields.length == 0) {
            return true;
        }
        if (sortFields.length > 1) {
            return false;
        }
        if (!Arrays.equals(groupByPath, sortFields[0].getPath().asArrayPath())) {
            return false;
        }
        return metadata.isSortable(sortFields[0].getPath().asArrayPath());
    }
}

