/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.IndexMergeConfiguration;
import org.infinispan.configuration.cache.IndexReaderConfiguration;
import org.infinispan.configuration.cache.IndexShardingConfiguration;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.search.mapper.mapping.impl.CompositeAnalysisConfigurer;

public class SearchPropertyExtractor {
    private static final String BACKEND_PREFIX = "hibernate.search.backend.";
    private static final String DIRECTORY_ROOT_KEY = "hibernate.search.backend.directory.root";
    private static final String DIRECTORY_PROVIDER_KEY = "hibernate.search.backend.directory.type";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER = "local-heap";
    private static final String FS_PROVIDER = "local-filesystem";
    private static final String REFRESH_INTERVAL_KEY = "hibernate.search.backend.io.refresh_interval";
    private static final String IO_PREFIX = "hibernate.search.backend.io.";
    private static final String COMMIT_INTERVAL_KEY = "hibernate.search.backend.io.commit_interval";
    private static final String RAM_BUFFER_KEY = "hibernate.search.backend.io.writer.ram_buffer_size";
    private static final String MAX_BUFFER_DOCS_KEY = "hibernate.search.backend.io.writer.max_buffered_docs";
    private static final String LOW_LEVEL_TRACE_KEY = "hibernate.search.backend.io.writer.infostream";
    private static final String QUEUE_COUNT_KEY = "hibernate.search.backend.indexing.queue_count";
    private static final String QUEUE_SIZE_KEY = "hibernate.search.backend.indexing.queue_size";
    private static final String THREAD_POOL_KEY = "hibernate.search.backend.thread_pool.size";
    private static final String KEY_PREFIX = "hibernate.search.backend.io.merge";
    private static final String MAX_DOCS_KEY = "hibernate.search.backend.io.merge.max_docs";
    private static final String FACTOR_KEY = "hibernate.search.backend.io.merge.factor";
    private static final String MIN_SIZE_KEY = "hibernate.search.backend.io.merge.min_size";
    private static final String MAX_SIZE_KEY = "hibernate.search.backend.io.merge.max_size";
    private static final String MAX_FORCED_SIZE_KEY = "hibernate.search.backend.io.merge.max_forced_size";
    private static final String CALIBRATE_BY_DELETES_KEY = "hibernate.search.backend.io.merge.calibrate_by_deletes";
    private static final String ANALYSIS_CONFIGURER_PROPERTY_NAME = "analysis.configurer";

    public static Map<String, Object> extractProperties(GlobalConfiguration globalConfiguration, String cacheName, IndexingConfiguration configuration, ClassLoader aggregatedClassLoader) {
        Integer numberOfShards;
        IndexShardingConfiguration sharding;
        Boolean calibrateByDeletes;
        Integer maxForcedSize;
        Integer factor;
        Integer maxSize;
        Integer minSize;
        IndexMergeConfiguration mergeConfiguration;
        Integer maxDocs;
        Boolean lowLevelTrace;
        Integer maxBufferedDocs;
        Integer ramBufferSize;
        Integer queueSize;
        Integer queueCount;
        Integer threadPoolSize;
        IndexWriterConfiguration writerConfiguration;
        Integer commitInterval;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Collection analyzerDefProviders = ServiceFinder.load(LuceneAnalysisConfigurer.class, (ClassLoader[])new ClassLoader[]{aggregatedClassLoader});
        if (analyzerDefProviders.size() == 1) {
            props.put(ANALYSIS_CONFIGURER_PROPERTY_NAME, analyzerDefProviders.iterator().next());
        } else if (!analyzerDefProviders.isEmpty()) {
            props.put(ANALYSIS_CONFIGURER_PROPERTY_NAME, new CompositeAnalysisConfigurer(analyzerDefProviders));
        }
        if (!configuration.enabled()) {
            return Collections.unmodifiableMap(props);
        }
        IndexStorage storage = configuration.storage();
        if (storage.equals((Object)IndexStorage.LOCAL_HEAP)) {
            props.put(DIRECTORY_PROVIDER_KEY, LOCAL_HEAP_DIRECTORY_PROVIDER);
        } else {
            props.put(DIRECTORY_PROVIDER_KEY, FS_PROVIDER);
            Path location = SearchPropertyExtractor.getIndexLocation(globalConfiguration, configuration.path(), cacheName);
            props.put(DIRECTORY_ROOT_KEY, location.toFile().getPath());
        }
        IndexReaderConfiguration readerConfiguration = configuration.reader();
        long refreshInterval = readerConfiguration.getRefreshInterval();
        if (refreshInterval != 0L) {
            props.put(REFRESH_INTERVAL_KEY, refreshInterval);
        }
        if ((commitInterval = (writerConfiguration = configuration.writer()).getCommitInterval()) != null) {
            props.put(COMMIT_INTERVAL_KEY, commitInterval);
        }
        if ((threadPoolSize = writerConfiguration.getThreadPoolSize()) != null) {
            props.put(THREAD_POOL_KEY, threadPoolSize);
        }
        if ((queueCount = writerConfiguration.getQueueCount()) != null) {
            props.put(QUEUE_COUNT_KEY, queueCount);
        }
        if ((queueSize = writerConfiguration.getQueueSize()) != null) {
            props.put(QUEUE_SIZE_KEY, queueSize);
        }
        if ((ramBufferSize = writerConfiguration.getRamBufferSize()) != null) {
            props.put(RAM_BUFFER_KEY, ramBufferSize);
        }
        if ((maxBufferedDocs = writerConfiguration.getMaxBufferedEntries()) != null) {
            props.put(MAX_BUFFER_DOCS_KEY, maxBufferedDocs);
        }
        if ((lowLevelTrace = writerConfiguration.isLowLevelTrace()).booleanValue()) {
            props.put(LOW_LEVEL_TRACE_KEY, true);
        }
        if ((maxDocs = (mergeConfiguration = writerConfiguration.merge()).maxEntries()) != null) {
            props.put(MAX_DOCS_KEY, maxDocs);
        }
        if ((minSize = mergeConfiguration.minSize()) != null) {
            props.put(MIN_SIZE_KEY, minSize);
        }
        if ((maxSize = mergeConfiguration.maxSize()) != null) {
            props.put(MAX_SIZE_KEY, maxSize);
        }
        if ((factor = mergeConfiguration.factor()) != null) {
            props.put(FACTOR_KEY, factor);
        }
        if ((maxForcedSize = mergeConfiguration.maxForcedSize()) != null) {
            props.put(MAX_FORCED_SIZE_KEY, maxForcedSize);
        }
        if ((calibrateByDeletes = mergeConfiguration.calibrateByDeletes()) != null) {
            props.put(CALIBRATE_BY_DELETES_KEY, calibrateByDeletes);
        }
        if ((sharding = configuration.sharding()) != null && (numberOfShards = sharding.getShards()) > 1) {
            props.put("sharding.strategy", "hash");
            props.put("sharding.number_of_shards", numberOfShards);
        }
        return Collections.unmodifiableMap(props);
    }

    public static Path getIndexLocation(GlobalConfiguration globalConfiguration, String location, String cacheName) {
        GlobalStateConfiguration globalState = globalConfiguration.globalState();
        Path persistentLocation = Paths.get(globalState.persistentLocation(), new String[0]);
        if (location == null) {
            return persistentLocation.resolve(cacheName);
        }
        Path path = Paths.get(location, new String[0]);
        return path.isAbsolute() ? path : persistentLocation.resolve(path);
    }
}

