/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public final class QueryResponse {
    private final NodeTopDocs nodeTopDocs;
    private final int resultSize;
    private final boolean countIsExact;

    public QueryResponse(int resultSize) {
        this.resultSize = resultSize;
        this.countIsExact = true;
        this.nodeTopDocs = null;
    }

    public QueryResponse(NodeTopDocs nodeTopDocs) {
        this.resultSize = nodeTopDocs.totalHitCount;
        this.countIsExact = nodeTopDocs.countIsExact;
        this.nodeTopDocs = nodeTopDocs;
    }

    public NodeTopDocs getNodeTopDocs() {
        return this.nodeTopDocs;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public boolean countIsExact() {
        return this.countIsExact;
    }

    public static final class Externalizer
    implements AdvancedExternalizer<QueryResponse> {
        public Set<Class<? extends QueryResponse>> getTypeClasses() {
            return Collections.singleton(QueryResponse.class);
        }

        public Integer getId() {
            return ExternalizerIds.CLUSTERED_QUERY_COMMAND_RESPONSE;
        }

        public void writeObject(ObjectOutput output, QueryResponse queryResponse) throws IOException {
            output.writeObject(queryResponse.nodeTopDocs);
            if (queryResponse.nodeTopDocs == null) {
                output.writeInt(queryResponse.resultSize);
            }
        }

        public QueryResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            NodeTopDocs nodeTopDocs = (NodeTopDocs)input.readObject();
            if (nodeTopDocs != null) {
                return new QueryResponse(nodeTopDocs);
            }
            return new QueryResponse(input.readInt());
        }
    }
}

