/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.Indexer;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.core.impl.EmbeddedQueryFactory;
import org.infinispan.query.core.impl.continuous.ContinuousQueryImpl;
import org.infinispan.query.core.impl.eventfilter.IckleCacheEventFilterConverter;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.core.stats.SearchStatisticsSnapshot;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.ObjectReflectionMatcher;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.actions.SecurityActions;

public final class Search {
    private Search() {
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString) {
        return Search.makeFilter(queryString, null);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString, Map<String, Object> namedParameters) {
        IckleFilterAndConverter filterAndConverter = new IckleFilterAndConverter(queryString, namedParameters, ObjectReflectionMatcher.class);
        return new IckleCacheEventFilterConverter(filterAndConverter);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(Query<?> query) {
        return Search.makeFilter(query.getQueryString(), query.getParameters());
    }

    public static QueryFactory getQueryFactory(Cache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("The cache parameter cannot be null.");
        }
        AdvancedCache advancedCache = cache.getAdvancedCache();
        if (advancedCache == null) {
            throw new IllegalArgumentException("The given cache must expose an AdvancedCache interface.");
        }
        Search.checkBulkReadPermission(advancedCache);
        QueryEngine<Class<?>> queryEngine = ComponentRegistryUtils.getEmbeddedQueryEngine(advancedCache);
        return new EmbeddedQueryFactory(queryEngine);
    }

    @Deprecated
    public static <K, V> ContinuousQuery<K, V> getContinuousQuery(Cache<K, V> cache) {
        return new ContinuousQueryImpl(cache);
    }

    private static <K, V> AdvancedCache<K, V> getAdvancedCache(Cache<K, V> cache) {
        AdvancedCache advancedCache = Objects.requireNonNull(cache, "The cache parameter cannot be null.").getAdvancedCache();
        if (advancedCache == null) {
            throw new IllegalArgumentException("The given cache must expose an AdvancedCache interface.");
        }
        Search.checkBulkReadPermission(advancedCache);
        return advancedCache;
    }

    public static <K, V> Indexer getIndexer(Cache<K, V> cache) {
        AdvancedCache<K, V> advancedCache = Search.getAdvancedCache(cache);
        return ComponentRegistryUtils.getIndexer(advancedCache);
    }

    private static void checkBulkReadPermission(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
    }

    public static <K, V> SearchStatistics getSearchStatistics(Cache<K, V> cache) {
        return ComponentRegistryUtils.getSearchStatsRetriever(cache).getSearchStatistics();
    }

    public static CompletionStage<SearchStatisticsSnapshot> getClusteredSearchStatistics(Cache<?, ?> cache) {
        return ComponentRegistryUtils.getSearchStatsRetriever(cache).getDistributedSearchStatistics();
    }
}

