/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class TrimFunction<K, V>
implements ListBucketBaseFunction<K, V, Boolean> {
    public static final AdvancedExternalizer<TrimFunction> EXTERNALIZER = new Externalizer();
    private final long from;
    private final long to;

    public TrimFunction(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket bucket = (ListBucket)existing.get();
            bucket.trim(this.from, this.to);
            if (bucket.isEmpty()) {
                entryView.remove();
            }
            return true;
        }
        return false;
    }

    private static class Externalizer
    implements AdvancedExternalizer<TrimFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends TrimFunction>> getTypeClasses() {
            return Collections.singleton(TrimFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.TRIM_FUNCTION;
        }

        public void writeObject(ObjectOutput output, TrimFunction object) throws IOException {
            output.writeLong(object.from);
            output.writeLong(object.to);
        }

        public TrimFunction readObject(ObjectInput input) throws IOException {
            return new TrimFunction(input.readLong(), input.readLong());
        }
    }
}

