/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScanSeed<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Supplier<R> seedSupplier;

    public FlowableScanSeed(Flowable<T> source, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = accumulator;
        this.seedSupplier = seedSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        R r;
        try {
            r = Objects.requireNonNull(this.seedSupplier.get(), "The seed supplied is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptySubscription.error(e, s);
            return;
        }
        this.source.subscribe(new ScanSeedSubscriber<T, R>(s, this.accumulator, r, FlowableScanSeed.bufferSize()));
    }

    static final class ScanSeedSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1776795561228106469L;
        final Subscriber<? super R> downstream;
        final BiFunction<R, ? super T, R> accumulator;
        final SimplePlainQueue<R> queue;
        final AtomicLong requested;
        final int prefetch;
        final int limit;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        Subscription upstream;
        R value;
        int consumed;

        ScanSeedSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value, int prefetch) {
            this.downstream = actual;
            this.accumulator = accumulator;
            this.value = value;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.queue = new SpscArrayQueue<R>(prefetch);
            this.queue.offer(value);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(this.prefetch - 1);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            R v = this.value;
            try {
                v = Objects.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.value = v;
            this.queue.offer(v);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> a = this.downstream;
            SimplePlainQueue<R> q = this.queue;
            int lim = this.limit;
            int c = this.consumed;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    R v = q.poll();
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (++c != lim) continue;
                    c = 0;
                    this.upstream.request(lim);
                }
                if (e == r && this.done) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    if (q.isEmpty()) {
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L) {
                    BackpressureHelper.produced(this.requested, e);
                }
                this.consumed = c;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

