/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.GraphInput;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import io.protostuff.StatefulOutput;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.PolymorphicSchema;
import io.protostuff.runtime.RuntimeFieldFactory;
import java.io.IOException;

public abstract class NumberSchema
extends PolymorphicSchema {
    protected final Pipe.Schema<Object> pipeSchema = new Pipe.Schema<Object>((Schema)this){

        @Override
        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            NumberSchema.transferObject(this, pipe, input, output, NumberSchema.this.strategy);
        }
    };

    static String name(int number) {
        switch (number) {
            case 2: {
                return "b";
            }
            case 4: {
                return "d";
            }
            case 5: {
                return "e";
            }
            case 6: {
                return "f";
            }
            case 7: {
                return "g";
            }
            case 8: {
                return "h";
            }
            case 12: {
                return "l";
            }
            case 13: {
                return "m";
            }
            case 127: {
                return "_";
            }
        }
        return null;
    }

    static int number(String name) {
        if (name.length() != 1) {
            return 0;
        }
        switch (name.charAt(0)) {
            case '_': {
                return 127;
            }
            case 'b': {
                return 2;
            }
            case 'd': {
                return 4;
            }
            case 'e': {
                return 5;
            }
            case 'f': {
                return 6;
            }
            case 'g': {
                return 7;
            }
            case 'h': {
                return 8;
            }
            case 'l': {
                return 12;
            }
            case 'm': {
                return 13;
            }
        }
        return 0;
    }

    public NumberSchema(IdStrategy strategy) {
        super(strategy);
    }

    @Override
    public Pipe.Schema<Object> getPipeSchema() {
        return this.pipeSchema;
    }

    @Override
    public String getFieldName(int number) {
        return NumberSchema.name(number);
    }

    @Override
    public int getFieldNumber(String name) {
        return NumberSchema.number(name);
    }

    @Override
    public String messageFullName() {
        return Number.class.getName();
    }

    @Override
    public String messageName() {
        return Number.class.getSimpleName();
    }

    @Override
    public void mergeFrom(Input input, Object owner) throws IOException {
        this.setValue(NumberSchema.readObjectFrom(input, this, owner, this.strategy), owner);
    }

    @Override
    public void writeTo(Output output, Object value) throws IOException {
        NumberSchema.writeObjectTo(output, value, this, this.strategy);
    }

    static void writeObjectTo(Output output, Object value, Schema<?> currentSchema, IdStrategy strategy) throws IOException {
        Class<?> clazz = value.getClass();
        RuntimeFieldFactory<?> inline = RuntimeFieldFactory.getInline(clazz);
        if (inline != null) {
            inline.writeTo(output, inline.id, value, false);
            return;
        }
        Schema<?> schema = strategy.writePojoIdTo(output, 127, clazz).getSchema();
        if (output instanceof StatefulOutput) {
            ((StatefulOutput)output).updateLast(schema, currentSchema);
        }
        schema.writeTo(output, value);
    }

    static Object readObjectFrom(Input input, Schema<?> schema, Object owner, IdStrategy strategy) throws IOException {
        Object value;
        int number = input.readFieldNumber(schema);
        if (number == 127) {
            Schema derivedSchema = strategy.resolvePojoFrom(input, number).getSchema();
            Object pojo = derivedSchema.newMessage();
            if (input instanceof GraphInput) {
                ((GraphInput)input).updateLast(pojo, owner);
            }
            derivedSchema.mergeFrom(input, pojo);
            return pojo;
        }
        switch (number) {
            case 2: {
                value = RuntimeFieldFactory.BYTE.readFrom(input);
                break;
            }
            case 4: {
                value = RuntimeFieldFactory.SHORT.readFrom(input);
                break;
            }
            case 5: {
                value = RuntimeFieldFactory.INT32.readFrom(input);
                break;
            }
            case 6: {
                value = RuntimeFieldFactory.INT64.readFrom(input);
                break;
            }
            case 7: {
                value = RuntimeFieldFactory.FLOAT.readFrom(input);
                break;
            }
            case 8: {
                value = RuntimeFieldFactory.DOUBLE.readFrom(input);
                break;
            }
            case 12: {
                value = RuntimeFieldFactory.BIGDECIMAL.readFrom(input);
                break;
            }
            case 13: {
                value = RuntimeFieldFactory.BIGINTEGER.readFrom(input);
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
        if (input instanceof GraphInput) {
            ((GraphInput)input).updateLast(value, owner);
        }
        if (0 != input.readFieldNumber(schema)) {
            throw new ProtostuffException("Corrupt input.");
        }
        return value;
    }

    static void transferObject(Pipe.Schema<Object> pipeSchema, Pipe pipe, Input input, Output output, IdStrategy strategy) throws IOException {
        int number = input.readFieldNumber(pipeSchema.wrappedSchema);
        if (number == 127) {
            Pipe.Schema derivedPipeSchema = strategy.transferPojoId(input, output, number).getPipeSchema();
            if (output instanceof StatefulOutput) {
                ((StatefulOutput)output).updateLast(derivedPipeSchema, pipeSchema);
            }
            Pipe.transferDirect(derivedPipeSchema, pipe, input, output);
            return;
        }
        switch (number) {
            case 2: {
                RuntimeFieldFactory.BYTE.transfer(pipe, input, output, number, false);
                break;
            }
            case 4: {
                RuntimeFieldFactory.SHORT.transfer(pipe, input, output, number, false);
                break;
            }
            case 5: {
                RuntimeFieldFactory.INT32.transfer(pipe, input, output, number, false);
                break;
            }
            case 6: {
                RuntimeFieldFactory.INT64.transfer(pipe, input, output, number, false);
                break;
            }
            case 7: {
                RuntimeFieldFactory.FLOAT.transfer(pipe, input, output, number, false);
                break;
            }
            case 8: {
                RuntimeFieldFactory.DOUBLE.transfer(pipe, input, output, number, false);
                break;
            }
            case 12: {
                RuntimeFieldFactory.BIGDECIMAL.transfer(pipe, input, output, number, false);
                break;
            }
            case 13: {
                RuntimeFieldFactory.BIGINTEGER.transfer(pipe, input, output, number, false);
                break;
            }
            default: {
                throw new ProtostuffException("Corrupt input.");
            }
        }
    }
}

