/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.ProtostuffException;
import io.protostuff.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public abstract class MapSchema<K, V>
implements Schema<Map<K, V>> {
    static final Set<String> MESSAGE_FACTORIES_NAMES;
    public static final String FIELD_NAME_ENTRY = "e";
    public static final String FIELD_NAME_KEY = "k";
    public static final String FIELD_NAME_VALUE = "v";
    public final MessageFactory messageFactory;
    public final Pipe.Schema<Map<K, V>> pipeSchema = new Pipe.Schema<Map<K, V>>(this){

        @Override
        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(MapSchema.this);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        output.writeObject(number, pipe, MapSchema.this.entryPipeSchema, true);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(MapSchema.this);
            }
        }
    };
    private final Schema<Map.Entry<K, V>> entrySchema = new Schema<Map.Entry<K, V>>(){

        @Override
        public final String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return MapSchema.FIELD_NAME_KEY;
                }
                case 2: {
                    return MapSchema.FIELD_NAME_VALUE;
                }
            }
            return null;
        }

        @Override
        public final int getFieldNumber(String name) {
            if (name.length() != 1) {
                return 0;
            }
            switch (name.charAt(0)) {
                case 'k': {
                    return 1;
                }
                case 'v': {
                    return 2;
                }
            }
            return 0;
        }

        @Override
        public boolean isInitialized(Map.Entry<K, V> message) {
            return true;
        }

        @Override
        public String messageFullName() {
            return Map.Entry.class.getName();
        }

        @Override
        public String messageName() {
            return Map.Entry.class.getSimpleName();
        }

        @Override
        public Map.Entry<K, V> newMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<? super Map.Entry<K, V>> typeClass() {
            return Map.Entry.class;
        }

        @Override
        public void mergeFrom(Input input, Map.Entry<K, V> message) throws IOException {
            MapWrapper wrapper = (MapWrapper)message;
            Object key = null;
            boolean valueRetrieved = false;
            int number = input.readFieldNumber(this);
            while (true) {
                switch (number) {
                    case 0: {
                        if (key == null) {
                            wrapper.map.put(null, valueRetrieved ? (Object)wrapper.value : null);
                        } else if (!valueRetrieved) {
                            wrapper.map.put(key, null);
                        }
                        return;
                    }
                    case 1: {
                        if (key != null) {
                            throw new ProtostuffException("The map was incorrectly serialized.");
                        }
                        key = MapSchema.this.readKeyFrom(input, wrapper);
                        assert (key != null);
                        break;
                    }
                    case 2: {
                        if (valueRetrieved) {
                            throw new ProtostuffException("The map was incorrectly serialized.");
                        }
                        valueRetrieved = true;
                        MapSchema.this.putValueFrom(input, wrapper, key);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(this);
            }
        }

        @Override
        public void writeTo(Output output, Map.Entry<K, V> message) throws IOException {
            if (message.getKey() != null) {
                MapSchema.this.writeKeyTo(output, 1, message.getKey(), false);
            }
            if (message.getValue() != null) {
                MapSchema.this.writeValueTo(output, 2, message.getValue(), false);
            }
        }
    };
    private final Pipe.Schema<Map.Entry<K, V>> entryPipeSchema = new Pipe.Schema<Map.Entry<K, V>>(this.entrySchema){

        @Override
        protected void transfer(Pipe pipe, Input input, Output output) throws IOException {
            int number = input.readFieldNumber(MapSchema.this.entrySchema);
            while (true) {
                switch (number) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        MapSchema.this.transferKey(pipe, input, output, 1, false);
                        break;
                    }
                    case 2: {
                        MapSchema.this.transferValue(pipe, input, output, 2, false);
                        break;
                    }
                    default: {
                        throw new ProtostuffException("The map was incorrectly serialized.");
                    }
                }
                number = input.readFieldNumber(MapSchema.this.entrySchema);
            }
        }
    };

    public MapSchema() {
        this(MessageFactories.HashMap);
    }

    public MapSchema(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected abstract K readKeyFrom(Input var1, MapWrapper<K, V> var2) throws IOException;

    protected abstract void putValueFrom(Input var1, MapWrapper<K, V> var2, K var3) throws IOException;

    protected abstract void writeKeyTo(Output var1, int var2, K var3, boolean var4) throws IOException;

    protected abstract void writeValueTo(Output var1, int var2, V var3, boolean var4) throws IOException;

    protected abstract void transferKey(Pipe var1, Input var2, Output var3, int var4, boolean var5) throws IOException;

    protected abstract void transferValue(Pipe var1, Input var2, Output var3, int var4, boolean var5) throws IOException;

    @Override
    public final String getFieldName(int number) {
        return number == 1 ? FIELD_NAME_ENTRY : null;
    }

    @Override
    public final int getFieldNumber(String name) {
        return name.length() == 1 && name.charAt(0) == 'e' ? 1 : 0;
    }

    @Override
    public final boolean isInitialized(Map<K, V> map) {
        return true;
    }

    @Override
    public final String messageFullName() {
        return Map.class.getName();
    }

    @Override
    public final String messageName() {
        return Map.class.getSimpleName();
    }

    @Override
    public final Class<? super Map<K, V>> typeClass() {
        return Map.class;
    }

    @Override
    public final Map<K, V> newMessage() {
        return this.messageFactory.newMessage();
    }

    @Override
    public final void mergeFrom(Input input, Map<K, V> map) throws IOException {
        MapWrapper<K, V> entry = null;
        int number = input.readFieldNumber(this);
        while (true) {
            switch (number) {
                case 0: {
                    return;
                }
                case 1: {
                    if (entry == null) {
                        entry = new MapWrapper<K, V>(map);
                    }
                    if (entry == input.mergeObject(entry, this.entrySchema)) break;
                    throw new IllegalStateException("A Map.Entry will always be unique, hence it cannot be a reference obtained from " + input.getClass().getName());
                }
                default: {
                    throw new ProtostuffException("The map was incorrectly serialized.");
                }
            }
            number = input.readFieldNumber(this);
        }
    }

    @Override
    public final void writeTo(Output output, Map<K, V> map) throws IOException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            output.writeObject(1, entry, this.entrySchema, true);
        }
    }

    static {
        MessageFactories[] messageFactories = MessageFactories.values();
        MESSAGE_FACTORIES_NAMES = new HashSet<String>(messageFactories.length);
        for (MessageFactories messageFactory : messageFactories) {
            MESSAGE_FACTORIES_NAMES.add(messageFactory.name());
        }
    }

    public static final class MapWrapper<K, V>
    implements Map.Entry<K, V> {
        final Map<K, V> map;
        V value;

        MapWrapper(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public K getKey() {
            return null;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V last = this.value;
            this.value = value;
            return last;
        }

        public void put(K key, V value) {
            if (key == null) {
                this.value = value;
            } else {
                this.map.put(key, value);
            }
        }
    }

    public static enum MessageFactories implements MessageFactory
    {
        Map((Class)HashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new HashMap();
            }
        }
        ,
        SortedMap((Class)TreeMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new TreeMap();
            }
        }
        ,
        NavigableMap((Class)TreeMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new TreeMap();
            }
        }
        ,
        HashMap((Class)HashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new HashMap();
            }
        }
        ,
        LinkedHashMap((Class)LinkedHashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new LinkedHashMap();
            }
        }
        ,
        TreeMap((Class)TreeMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new TreeMap();
            }
        }
        ,
        WeakHashMap((Class)WeakHashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new WeakHashMap();
            }
        }
        ,
        IdentityHashMap((Class)IdentityHashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new IdentityHashMap();
            }
        }
        ,
        Hashtable((Class)Hashtable.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new Hashtable();
            }
        }
        ,
        ConcurrentMap((Class)ConcurrentHashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new ConcurrentHashMap();
            }
        }
        ,
        ConcurrentHashMap((Class)ConcurrentHashMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new ConcurrentHashMap();
            }
        }
        ,
        ConcurrentNavigableMap((Class)ConcurrentSkipListMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new ConcurrentSkipListMap();
            }
        }
        ,
        ConcurrentSkipListMap((Class)ConcurrentSkipListMap.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new ConcurrentSkipListMap();
            }
        }
        ,
        Properties((Class)Properties.class){

            @Override
            public <K, V> Map<K, V> newMessage() {
                return new Properties();
            }
        };

        public final Class<?> typeClass;

        private MessageFactories(Class<?> typeClass) {
            this.typeClass = typeClass;
        }

        @Override
        public Class<?> typeClass() {
            return this.typeClass;
        }

        public static MessageFactories getFactory(Class<? extends Map<?, ?>> mapType) {
            return mapType.getName().startsWith("java.util") ? MessageFactories.valueOf(mapType.getSimpleName()) : null;
        }

        public static MessageFactories getFactory(String name) {
            return MessageFactories.valueOf(name);
        }

        public static boolean accept(String name) {
            return MESSAGE_FACTORIES_NAMES.contains(name);
        }
    }

    public static interface MessageFactory {
        public <K, V> Map<K, V> newMessage();

        public Class<?> typeClass();
    }
}

