/*
 * Decompiled with CFR 0.152.
 */
package protostream.com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import protostream.com.squareup.protoparser.AutoValue_FieldElement;
import protostream.com.squareup.protoparser.DataType;
import protostream.com.squareup.protoparser.OptionElement;
import protostream.com.squareup.protoparser.ProtoFile;
import protostream.com.squareup.protoparser.Utils;

public abstract class FieldElement {
    public static Builder builder() {
        return new Builder();
    }

    FieldElement() {
    }

    public abstract Label label();

    public abstract DataType type();

    public abstract String name();

    public abstract int tag();

    public abstract String documentation();

    public abstract List<OptionElement> options();

    public final boolean isDeprecated() {
        OptionElement deprecatedOption = OptionElement.findByName(this.options(), "deprecated");
        return deprecatedOption != null && "true".equals(deprecatedOption.value());
    }

    public final boolean isPacked() {
        OptionElement packedOption = OptionElement.findByName(this.options(), "packed");
        return packedOption != null && "true".equals(packedOption.value());
    }

    public final OptionElement getDefault() {
        OptionElement defaultOption = OptionElement.findByName(this.options(), "default");
        return defaultOption != null ? defaultOption : null;
    }

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation());
        if (this.label() != Label.ONE_OF) {
            builder.append(this.label().name().toLowerCase(Locale.US)).append(' ');
        }
        builder.append(this.type()).append(' ').append(this.name()).append(" = ").append(this.tag());
        if (!this.options().isEmpty()) {
            builder.append(" [\n");
            for (OptionElement option : this.options()) {
                Utils.appendIndented(builder, option.toSchema());
            }
            builder.append(']');
        }
        return builder.append(";\n").toString();
    }

    public static final class Builder {
        private Label label;
        private DataType type;
        private String name;
        private Integer tag;
        private String documentation = "";
        private final List<OptionElement> options = new ArrayList<OptionElement>();

        private Builder() {
        }

        public Builder label(Label label) {
            this.label = Utils.checkNotNull(label, "label");
            return this;
        }

        public Builder type(DataType type) {
            this.type = Utils.checkNotNull(type, "type");
            return this;
        }

        public Builder name(String name) {
            this.name = Utils.checkNotNull(name, "name");
            return this;
        }

        public Builder tag(int tag) {
            this.tag = tag;
            return this;
        }

        public Builder documentation(String documentation) {
            this.documentation = Utils.checkNotNull(documentation, "documentation");
            return this;
        }

        public Builder addOption(OptionElement option) {
            this.options.add(Utils.checkNotNull(option, "option"));
            return this;
        }

        public Builder addOptions(Collection<OptionElement> options) {
            for (OptionElement option : Utils.checkNotNull(options, "options")) {
                this.addOption(option);
            }
            return this;
        }

        public FieldElement build() {
            Utils.checkNotNull(this.label, "label");
            Utils.checkNotNull(this.type, "type");
            Utils.checkNotNull(this.name, "name");
            Utils.checkNotNull(this.tag, "tag");
            Utils.checkArgument(ProtoFile.isValidTag(this.tag), "Illegal tag value: %s", this.tag);
            return new AutoValue_FieldElement(this.label, this.type, this.name, this.tag, this.documentation, Utils.immutableCopyOf(this.options));
        }
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED,
        ONE_OF;

    }
}

