/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.EventListener;
import org.jboss.threads.Messages;
import org.jboss.threads.ShutdownListenable;
import org.jboss.threads.SimpleShutdownListenable;
import org.jboss.threads.management.ThreadPoolExecutorMBean;

public final class JBossScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements ThreadPoolExecutorMBean,
ShutdownListenable {
    private final SimpleShutdownListenable shutdownListenable = new SimpleShutdownListenable();
    private final AtomicInteger rejectCount = new AtomicInteger();

    public JBossScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
        this.setRejectedExecutionHandler(super.getRejectedExecutionHandler());
    }

    public JBossScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.setRejectedExecutionHandler(super.getRejectedExecutionHandler());
    }

    public JBossScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize);
        this.setRejectedExecutionHandler(handler);
    }

    public JBossScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory);
        this.setRejectedExecutionHandler(handler);
    }

    @Override
    public long getKeepAliveTime() {
        return this.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        super.setKeepAliveTime(milliseconds, TimeUnit.MILLISECONDS);
        super.allowCoreThreadTimeOut(milliseconds < Long.MAX_VALUE);
    }

    @Override
    public void setKeepAliveTime(long time, TimeUnit unit) {
        super.setKeepAliveTime(time, unit);
        super.allowCoreThreadTimeOut(time < Long.MAX_VALUE);
    }

    @Override
    public int getRejectedCount() {
        return this.rejectCount.get();
    }

    @Override
    public int getCurrentThreadCount() {
        return this.getActiveCount();
    }

    @Override
    public int getLargestThreadCount() {
        return this.getLargestPoolSize();
    }

    @Override
    public int getMaxThreads() {
        return this.getCorePoolSize();
    }

    @Override
    public void setMaxThreads(int newSize) {
        this.setCorePoolSize(newSize);
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return ((CountingRejectHandler)super.getRejectedExecutionHandler()).getDelegate();
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        super.setRejectedExecutionHandler(new CountingRejectHandler(handler));
    }

    @Override
    public int getQueueSize() {
        return this.getQueue().size();
    }

    @Override
    public <A> void addShutdownListener(EventListener<A> shutdownListener, A attachment) {
        this.shutdownListenable.addShutdownListener(shutdownListener, attachment);
    }

    @Override
    protected void terminated() {
        this.shutdownListenable.shutdown();
    }

    private final class CountingRejectHandler
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public CountingRejectHandler(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        public RejectedExecutionHandler getDelegate() {
            return this.delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            JBossScheduledThreadPoolExecutor.this.rejectCount.incrementAndGet();
            if (JBossScheduledThreadPoolExecutor.this.isShutdown()) {
                throw Messages.msg.shutDownInitiated();
            }
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

