/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class SinglePostCompleteSubscriber<T, R>
extends AtomicLong
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = 7917814472626990048L;
    protected final Subscriber<? super R> downstream;
    protected Subscription upstream;
    protected R value;
    protected long produced;
    static final long COMPLETE_MASK = Long.MIN_VALUE;
    static final long REQUEST_MASK = Long.MAX_VALUE;

    public SinglePostCompleteSubscriber(Subscriber<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.upstream, s)) {
            this.upstream = s;
            this.downstream.onSubscribe(this);
        }
    }

    protected final void complete(R n) {
        long p = this.produced;
        if (p != 0L) {
            BackpressureHelper.produced(this, p);
        }
        while (true) {
            long r;
            if (((r = this.get()) & Long.MIN_VALUE) != 0L) {
                this.onDrop(n);
                return;
            }
            if ((r & Long.MAX_VALUE) != 0L) {
                this.lazySet(-9223372036854775807L);
                this.downstream.onNext(n);
                this.downstream.onComplete();
                return;
            }
            this.value = n;
            if (this.compareAndSet(0L, Long.MIN_VALUE)) {
                return;
            }
            this.value = null;
        }
    }

    protected void onDrop(R n) {
    }

    @Override
    public final void request(long n) {
        block2: {
            long u;
            long r;
            if (!SubscriptionHelper.validate(n)) break block2;
            do {
                if (((r = this.get()) & Long.MIN_VALUE) == 0L) continue;
                if (this.compareAndSet(Long.MIN_VALUE, -9223372036854775807L)) {
                    this.downstream.onNext(this.value);
                    this.downstream.onComplete();
                }
                break block2;
            } while (!this.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
            this.upstream.request(n);
        }
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }
}

