/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.ChannelOutputStream;
import org.infinispan.hotrod.impl.protocol.ChannelOutputStreamListener;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class PutStreamOperation<K>
extends AbstractKeyOperation<K, OutputStream>
implements ChannelOutputStreamListener {
    static final long VERSION_PUT = 0L;
    static final long VERSION_PUT_IF_ABSENT = -1L;
    private final long version;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();

    public PutStreamOperation(OperationContext operationContext, K key, byte[] keyBytes, CacheWriteOptions options, long version) {
        super(operationContext, (short)57, (short)58, key, keyBytes, (CacheOptions)options, null);
        this.version = version;
    }

    @Override
    public void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + codec.estimateExpirationSize(expiration) + 8);
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        codec.writeExpirationParams(buf, expiration);
        buf.writeLong(this.version);
        channel.writeAndFlush((Object)buf);
        this.complete(new ChannelOutputStream(channel, this));
    }

    @Override
    public void releaseChannel(Channel channel) {
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.closeFuture.completeExceptionally(ex);
        return super.completeExceptionally(ex);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status) || HotRodConstants.isNotExecuted(status) && this.version != 0L) {
            if (HotRodConstants.isSuccess(status)) {
                this.statsDataStore();
            }
            this.closeFuture.complete(null);
        } else {
            this.closeFuture.completeExceptionally(new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status)));
        }
    }

    @Override
    public void onError(Channel channel, Throwable error) {
        this.completeExceptionally(error);
    }

    @Override
    public void onClose(Channel channel) throws IOException {
        try {
            this.closeFuture.join();
        }
        catch (CompletionException e) {
            throw new IOException(e.getCause());
        }
        finally {
            if (channel.isActive()) {
                this.operationContext.getChannelFactory().releaseChannel(channel);
            }
        }
    }
}

