/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.configuration.ProtocolVersion;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class PingOperation
extends HotRodOperation<PingResponse>
implements ChannelOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private final boolean releaseChannel;
    private final PingResponse.Decoder responseBuilder;

    public PingOperation(OperationContext operationContext, boolean releaseChannel) {
        this(operationContext, 23, 24, releaseChannel);
    }

    protected PingOperation(OperationContext operationContext, short requestCode, short responseCode, boolean releaseChannel) {
        super(operationContext, requestCode, responseCode, CacheOptions.DEFAULT);
        this.releaseChannel = releaseChannel;
        this.responseBuilder = new PingResponse.Decoder(operationContext.getConfiguration().version());
    }

    @Override
    public void invoke(Channel channel) {
        this.sendHeaderAndRead(channel);
        if (this.releaseChannel) {
            this.releaseChannel(channel);
        }
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }

    @Override
    public CompletableFuture<PingResponse> execute() {
        throw new UnsupportedOperationException("Cannot execute directly");
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        PingResponse pingResponse;
        this.responseBuilder.processResponse(this.operationContext.getCodec(), buf, decoder);
        if (HotRodConstants.isSuccess(status)) {
            pingResponse = this.responseBuilder.build(status);
            if (pingResponse.getVersion() != null && this.operationContext.getConfiguration().version() == ProtocolVersion.PROTOCOL_VERSION_AUTO) {
                this.operationContext.setCodec(Codec.forProtocol(pingResponse.getVersion()));
            }
        } else {
            String hexStatus = Integer.toHexString(status);
            if (log.isTraceEnabled()) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    public void exceptionCaught(Channel channel, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
        } else {
            super.exceptionCaught(channel, cause);
        }
    }
}

