/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter;

import java.util.concurrent.CompletableFuture;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.counter.BaseCounter;
import org.infinispan.hotrod.impl.counter.CounterOperationFactory;
import org.infinispan.hotrod.impl.counter.NotificationManager;

class WeakCounterImpl
extends BaseCounter
implements WeakCounter {
    private final SyncWeakCounter syncCounter = new Sync();

    WeakCounterImpl(String name, CounterConfiguration configuration, CounterOperationFactory operationFactory, NotificationManager notificationManager) {
        super(configuration, name, operationFactory, notificationManager);
    }

    public long getValue() {
        return (Long)Util.await(this.factory.newGetValueOperation(this.name, this.useConsistentHash()).execute());
    }

    public CompletableFuture<Void> add(long delta) {
        return this.factory.newAddOperation(this.name, delta, this.useConsistentHash()).execute().thenRun(() -> {}).toCompletableFuture();
    }

    public SyncWeakCounter sync() {
        return this.syncCounter;
    }

    private class Sync
    implements SyncWeakCounter {
        private Sync() {
        }

        public String getName() {
            return WeakCounterImpl.this.name;
        }

        public long getValue() {
            return WeakCounterImpl.this.getValue();
        }

        public void add(long delta) {
            Util.await(WeakCounterImpl.this.add(delta));
        }

        public void reset() {
            Util.await(WeakCounterImpl.this.reset());
        }

        public CounterConfiguration getConfiguration() {
            return WeakCounterImpl.this.configuration;
        }

        public void remove() {
            Util.await(WeakCounterImpl.this.remove());
        }
    }
}

