/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.QuerySerializer;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.query.RemoteQuery;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public final class QueryOperation
extends RetryOnFailureOperation<Object> {
    private final RemoteQuery remoteQuery;
    private final QuerySerializer querySerializer;

    public QueryOperation(OperationContext operationContext, CacheOptions options, RemoteQuery remoteQuery, DataFormat dataFormat) {
        super(operationContext, (short)31, (short)32, options, dataFormat);
        this.remoteQuery = remoteQuery;
        this.querySerializer = QuerySerializer.findByMediaType(dataFormat.getValueType());
    }

    @Override
    protected void executeOperation(Channel channel) {
        byte[] requestBytes = this.querySerializer.serializeQueryRequest(this.remoteQuery, null);
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateVIntSize(requestBytes.length));
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeVInt(buf, requestBytes.length);
        channel.write((Object)buf);
        channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])requestBytes));
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        byte[] responseBytes = ByteBufUtil.readArray(buf);
    }
}

