/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.marshall.MarshallerUtil;

public class ExecuteOperation<T>
extends RetryOnFailureOperation<T> {
    private final String taskName;
    private final Map<String, byte[]> marshalledParams;
    private final Object key;

    protected ExecuteOperation(OperationContext operationContext, CacheOptions options, String taskName, Map<String, byte[]> marshalledParams, Object key, DataFormat dataFormat) {
        super(operationContext, (short)43, (short)44, options, dataFormat);
        this.taskName = taskName;
        this.marshalledParams = marshalledParams;
        this.key = key;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.key != null) {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.key, failedServers, this.operationContext.getCacheNameBytes(), this);
        } else {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(failedServers, this.operationContext.getCacheNameBytes(), this);
        }
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer();
        this.operationContext.getCodec().writeHeader(buf, this.header);
        ByteBufUtil.writeString(buf, this.taskName);
        ByteBufUtil.writeVInt(buf, this.marshalledParams.size());
        for (Map.Entry<String, byte[]> entry : this.marshalledParams.entrySet()) {
            ByteBufUtil.writeString(buf, entry.getKey());
            ByteBufUtil.writeArray(buf, entry.getValue());
        }
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(MarshallerUtil.bytes2obj(this.operationContext.getChannelFactory().getMarshaller(), ByteBufUtil.readArray(buf), this.dataFormat().isObjectStorage(), this.operationContext.getConfiguration().getClassAllowList()));
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append(", taskName=").append(this.taskName);
        sb.append(", params=[");
        Iterator<Map.Entry<String, byte[]>> iterator = this.marshalledParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            String name = entry.getKey();
            byte[] value = entry.getValue();
            sb.append(name).append("=").append(Util.toStr((Object)value));
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
    }
}

