/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.StringPropertyReplacer;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 3799321248100686287L;
    private static final Log log = LogFactory.getLog(TypedProperties.class);

    public TypedProperties(Properties p) {
        if (p != null && !p.isEmpty()) {
            super.putAll((Map<?, ?>)p);
        }
    }

    public TypedProperties() {
    }

    public static TypedProperties toTypedProperties(Properties p) {
        if (p instanceof TypedProperties) {
            return (TypedProperties)p;
        }
        return new TypedProperties(p);
    }

    public int getIntProperty(String key, int defaultValue) {
        return this.getIntProperty(key, defaultValue, false);
    }

    public int getIntProperty(String key, int defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            log.unableToConvertStringPropertyToInt(value, defaultValue);
            return defaultValue;
        }
    }

    public long getLongProperty(String key, long defaultValue) {
        return this.getLongProperty(key, defaultValue, false);
    }

    public long getLongProperty(String key, long defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties(value);
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            log.unableToConvertStringPropertyToLong(value, defaultValue);
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return this.getBooleanProperty(key, defaultValue, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties(value);
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            log.unableToConvertStringPropertyToBoolean(value, defaultValue);
            return defaultValue;
        }
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumClass, T defaultValue) {
        return this.getEnumProperty(key, enumClass, defaultValue, false);
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumClass, T defaultValue, boolean doStringReplace) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).length() == 0) {
            return defaultValue;
        }
        if (doStringReplace) {
            value = StringPropertyReplacer.replaceProperties(value);
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            log.unableToConvertStringPropertyToEnum(value, defaultValue.name());
            return defaultValue;
        }
    }

    public synchronized String getProperty(String key, String defaultValue, boolean doStringReplace) {
        if (doStringReplace) {
            return StringPropertyReplacer.replaceProperties(this.getProperty(key, defaultValue));
        }
        return this.getProperty(key, defaultValue);
    }

    @Override
    public synchronized TypedProperties putIfAbsent(String key, String value) {
        if (this.getProperty(key) == null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public synchronized TypedProperties setProperty(String key, String value) {
        super.setProperty(key, value);
        return this;
    }

    public synchronized TypedProperties setProperty(String key, int value) {
        super.setProperty(key, Integer.toString(value));
        return this;
    }

    public synchronized TypedProperties setProperty(String key, long value) {
        super.setProperty(key, Long.toString(value));
        return this;
    }

    public synchronized TypedProperties setProperty(String key, boolean value) {
        super.setProperty(key, Boolean.toString(value));
        return this;
    }
}

