/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.infinispan.commons.util.HopscotchHashMap;
import org.infinispan.commons.util.Immutables;

public class ImmutableHopscotchHashSet<E>
implements Set<E> {
    private static final Object PRESENT = new Object();
    private final HopscotchHashMap<E, Object> map;

    public ImmutableHopscotchHashSet(Collection<E> collection) {
        this.map = new HopscotchHashMap(collection.size());
        for (E e : collection) {
            this.map.put(e, PRESENT);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new Immutables.ImmutableIteratorWrapper(this.map.keySet().iterator());
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.map.keySet().forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException("removeIf");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }
}

