/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.util.Arrays;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1)
public class WrappedByteArray
implements WrappedBytes {
    public static final WrappedByteArray EMPTY_BYTES = new WrappedByteArray(Util.EMPTY_BYTE_ARRAY);
    private final byte[] bytes;
    private transient int hashCode;
    private transient boolean initializedHashCode;

    @ProtoFactory
    public WrappedByteArray(byte[] bytes) {
        this.bytes = bytes;
    }

    public WrappedByteArray(byte[] bytes, int hashCode) {
        this.bytes = bytes;
        assert (hashCode == Arrays.hashCode(bytes)) : "HashCode " + hashCode + " doesn't match " + Arrays.hashCode(bytes);
        this.hashCode = hashCode;
        this.initializedHashCode = true;
    }

    @Override
    @ProtoField(value=1)
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public int backArrayOffset() {
        return 0;
    }

    @Override
    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public byte getByte(int offset) {
        return this.bytes[offset];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Class<?> oClass = o.getClass();
        if (this.getClass() != oClass) {
            return WrappedBytes.class.isAssignableFrom(oClass) && this.equalsWrappedBytes((WrappedBytes)o);
        }
        WrappedByteArray that = (WrappedByteArray)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    @Override
    public boolean equalsWrappedBytes(WrappedBytes other) {
        int length = this.getLength();
        if (other.getLength() != length) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.getByte(i) == other.getByte(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.initializedHashCode) {
            this.hashCode = Arrays.hashCode(this.bytes);
            this.initializedHashCode = true;
        }
        return this.hashCode;
    }

    public String toString() {
        return "WrappedByteArray[" + Util.hexDump(this.bytes) + "]";
    }
}

