/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.ProgressTracker;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class ProgressTrackerTest {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    @AfterClass
    public static void stopExecutor() {
        executor.shutdown();
    }

    @Test
    public void testStartingAndCompletingTracker() {
        ProgressTracker tracker = new ProgressTracker("name", executor, (TimeService)new ControlledTimeService(), 10L, TimeUnit.MINUTES);
        tracker.addTasks(5L);
        Assert.assertEquals((long)5L, (long)tracker.pendingTasks());
        tracker.removeTasks(3L);
        Assert.assertEquals((long)2L, (long)tracker.pendingTasks());
        tracker.finishedAllTasks();
        Assert.assertEquals((long)0L, (long)tracker.pendingTasks());
    }

    @Test
    public void testStartAndComplete() {
        ProgressTracker tracker = new ProgressTracker("name", executor, (TimeService)new ControlledTimeService(), 10L, TimeUnit.MINUTES);
        tracker.addTasks(5L);
        Assert.assertEquals((long)5L, (long)tracker.pendingTasks());
        tracker.removeTasks(5L);
        Assert.assertEquals((long)0L, (long)tracker.pendingTasks());
        Assert.assertEquals((Object)ProgressTracker.Progression.PROGRESSING, (Object)tracker.currentTaskStatus());
        tracker.finishedAllTasks();
        Assert.assertEquals((long)0L, (long)tracker.pendingTasks());
        Assert.assertEquals((Object)ProgressTracker.Progression.DONE, (Object)tracker.currentTaskStatus());
    }

    @Test
    public void testTaskMovesToHang() {
        ProgressTracker tracker = new ProgressTracker("name", executor, (TimeService)new ControlledTimeService(), 500L, TimeUnit.MILLISECONDS);
        tracker.addTasks(5L);
        Assert.assertEquals((Object)ProgressTracker.Progression.IDLE, (Object)tracker.currentTaskStatus());
        tracker.addTasks(-2L);
        Assert.assertEquals((Object)ProgressTracker.Progression.PROGRESSING, (Object)tracker.currentTaskStatus());
        Eventually.eventually(() -> tracker.currentTaskStatus() == ProgressTracker.Progression.HANG, (long)2L, (TimeUnit)TimeUnit.SECONDS);
        tracker.finishedAllTasks();
        Assert.assertEquals((Object)ProgressTracker.Progression.DONE, (Object)tracker.currentTaskStatus());
    }

    @Test
    public void testTrackerIsReUtilized() {
        ProgressTracker tracker = new ProgressTracker("name", executor, (TimeService)new ControlledTimeService(), 10L, TimeUnit.MINUTES);
        for (int i = 0; i < 3; ++i) {
            tracker.addTasks(5L);
            Assert.assertEquals((Object)ProgressTracker.Progression.IDLE, (Object)tracker.currentTaskStatus());
            tracker.addTasks(-2L);
            Assert.assertEquals((Object)ProgressTracker.Progression.PROGRESSING, (Object)tracker.currentTaskStatus());
            tracker.finishedAllTasks();
            Assert.assertEquals((Object)ProgressTracker.Progression.DONE, (Object)tracker.currentTaskStatus());
        }
    }
}

