/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemLockTest {
    @After
    public void afterEach() {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{FileSystemLockTest.directoryName()}));
    }

    @Test
    public void testLockAndUnlock() throws Exception {
        String path = CommonsTestingUtil.tmpDirectory((String[])new String[]{FileSystemLockTest.directoryName()});
        FileSystemLock lock = new FileSystemLock(Paths.get(path, new String[0]), "test-1");
        Assert.assertTrue((boolean)lock.tryLock());
        Assert.assertTrue((boolean)lock.isAcquired());
        Assert.assertFalse((boolean)lock.tryLock());
        lock.unlock();
        Assert.assertFalse((boolean)lock.isAcquired());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleThreads() throws Exception {
        String path = CommonsTestingUtil.tmpDirectory((String[])new String[]{FileSystemLockTest.directoryName()});
        ExecutorService executor = Executors.newFixedThreadPool(4);
        try {
            ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
            CyclicBarrier barrier = new CyclicBarrier(5);
            ByRef.Integer counter = new ByRef.Integer(0);
            FileSystemLock lock = new FileSystemLock(Paths.get(path, new String[0]), "test-2");
            for (int i = 0; i < 4; ++i) {
                futures.add(CompletableFuture.supplyAsync(() -> {
                    try {
                        barrier.await(10L, TimeUnit.SECONDS);
                        if (lock.tryLock()) {
                            counter.inc();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }, executor));
            }
            barrier.await(10L, TimeUnit.SECONDS);
            futures.forEach(CompletableFuture::join);
            Assert.assertEquals((long)1L, (long)counter.get());
            Assert.assertFalse((boolean)lock.tryLock());
            lock.unlock();
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testUnsafeLocking() throws Exception {
        String path = CommonsTestingUtil.tmpDirectory((String[])new String[]{FileSystemLockTest.directoryName()});
        FileSystemLock lock = new FileSystemLock(Paths.get(path, new String[0]), "test-3");
        Assert.assertTrue((boolean)lock.tryLock());
        Assert.assertTrue((boolean)lock.isAcquired());
        lock.unsafeLock();
    }

    private static String directoryName() {
        return FileSystemLockTest.class.getSimpleName();
    }
}

