/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging.log4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.infinispan.commons.logging.log4j.XmlConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class XmlConfigurationTest {
    @Test
    public void testXmlConfiguration() throws IOException {
        Path path = XmlConfigurationTest.getConfigPath().resolve("log4j2-test.xml");
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            ConfigurationSource configurationSource = new ConfigurationSource(is, path.toFile());
            LoggerContext context = new LoggerContext("test");
            XmlConfiguration xmlConfiguration = new XmlConfiguration(context, configurationSource);
            xmlConfiguration.initialize();
            Assert.assertEquals((Object)"InfinispanTestConfig", (Object)xmlConfiguration.getName());
        }
    }

    public static Path getConfigPath() {
        return Paths.get(System.getProperty("build.directory"), "test-classes");
    }
}

