/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.TypedPropertiesAttributeCopier;
import org.infinispan.commons.util.TypedProperties;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTest {
    @Test
    public void testAttributeDefinitionType() {
        AttributeDefinition def = AttributeDefinition.builder((String)"long", (Object)10L).build();
        Assert.assertEquals(Long.class, (Object)def.getType());
        AttributeDefinition def2 = AttributeDefinition.builder((String)"string", null, String.class).build();
        Assert.assertEquals(String.class, (Object)def2.getType());
    }

    @Test
    public void testAttributeSetProtection() {
        AttributeDefinition immutable = AttributeDefinition.builder((String)"immutable", (Object)"").immutable().build();
        AttributeDefinition mutable = AttributeDefinition.builder((String)"mutable", (Object)"").build();
        AttributeSet set = new AttributeSet(this.getClass(), new AttributeDefinition[]{immutable, mutable});
        set.attribute(immutable).set((Object)"an immutable string");
        set.attribute(mutable).set((Object)"a mutable string");
        set = set.protect();
        try {
            set.attribute(immutable).set((Object)"this should fail");
            Assert.fail((String)"Changing an immutable attribute on a protected set should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        set.attribute(mutable).set((Object)"this should work");
    }

    @Test
    public void testAttributeChanges() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Assert.assertFalse((boolean)attribute.isModified());
        attribute.set((Object)true);
        Assert.assertEquals((Object)true, (Object)attribute.get());
        Assert.assertTrue((boolean)attribute.isModified());
    }

    @Test
    public void testAttributeInitializer() {
        AttributeDefinition def = AttributeDefinition.builder((String)"props", null, Properties.class).initializer(Properties::new).build();
        Attribute attribute1 = def.toAttribute();
        Attribute attribute2 = def.toAttribute();
        Assert.assertNotSame((Object)attribute1.get(), (Object)attribute2.get());
    }

    @Test
    public void testDefaultAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set((Object)true);
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
    }

    @Test
    public void testAttributeOverride() {
        AttributeDefinition one = AttributeDefinition.builder((String)"one", (Object)false).build();
        AttributeDefinition two = AttributeDefinition.builder((String)"two", (Object)false).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{one, two});
        set1.attribute(one).set((Object)true);
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{one, two});
        set2.attribute(two).set((Object)true);
        set2.read(set1, new Combine(Combine.RepeatedAttributes.OVERRIDE, Combine.Attributes.OVERRIDE));
        Assert.assertEquals((Object)set1.attribute(one).get(), (Object)set2.attribute(one).get());
        Assert.assertFalse((boolean)set2.attribute(two).isModified());
    }

    @Test
    public void testCollectionAttributeCopy() {
        AttributeDefinition def = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).copier(TypedPropertiesAttributeCopier.INSTANCE).initializer(TypedProperties::new).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        TypedProperties typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "value");
        set1.attribute(def).set((Object)typedProperties);
        set1 = set1.protect();
        typedProperties = (TypedProperties)set1.attribute(def).get();
        typedProperties.setProperty("key", "anotherValue");
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
    }

    @Test
    public void testCustomAttributeCopier() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", Arrays.asList("a", "b")).copier(attribute -> {
            if (attribute == null) {
                return null;
            }
            return new ArrayList(attribute);
        }).build();
        AttributeSet set1 = new AttributeSet("set", new AttributeDefinition[]{def});
        set1.attribute(def).set(Arrays.asList("b", "a"));
        AttributeSet set2 = new AttributeSet("set", new AttributeDefinition[]{def});
        set2.read(set1, Combine.DEFAULT);
        Assert.assertEquals((Object)set1.attribute(def).get(), (Object)set2.attribute(def).get());
        Assert.assertFalse((set1.attribute(def).get() == set2.attribute(def).get() ? 1 : 0) != 0);
    }

    @Test
    public void testAttributeListener() {
        AttributeDefinition def = AttributeDefinition.builder((String)"test", (Object)false).build();
        Attribute attribute = def.toAttribute();
        Holder<Boolean> listenerInvoked = new Holder<Boolean>(false);
        attribute.addListener((attribute1, oldValue) -> {
            Assert.assertTrue((boolean)((Boolean)attribute1.get()));
            Assert.assertFalse((boolean)oldValue);
            listenerInvoked.set(true);
        });
        attribute.set((Object)true);
        Assert.assertTrue((String)"Attribute listener was not invoked", (boolean)listenerInvoked.get());
    }

    @Test
    public void testAttributeSetMatches() {
        AttributeDefinition local = AttributeDefinition.builder((String)"local", (Object)"").global(false).build();
        AttributeDefinition global = AttributeDefinition.builder((String)"global", (Object)"").build();
        AttributeSet setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        AttributeSet setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setA.attribute("local").set((Object)"A");
        setA.attribute("global").set((Object)"A");
        setB.attribute("local").set((Object)"B");
        setB.attribute("global").set((Object)"A");
        Assert.assertTrue((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        setB.attribute("global").set((Object)"B");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local});
        setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setA.attribute("local").set((Object)"A");
        setB.attribute("local").set((Object)"A");
        setB.attribute("global").set((Object)"A");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
        AttributeDefinition global2 = AttributeDefinition.builder((String)"global2", (Object)"").build();
        setA = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global});
        setB = new AttributeSet(this.getClass(), new AttributeDefinition[]{local, global2});
        setA.attribute("local").set((Object)"A");
        setA.attribute("global").set((Object)"A");
        setB.attribute("local").set((Object)"A");
        setB.attribute("global2").set((Object)"A");
        Assert.assertFalse((boolean)setA.matches(setB));
        Assert.assertNotEquals((Object)setA, (Object)setB);
    }

    @Test
    public void testAttributeFromString() {
        AttributeDefinition stringArrayDef = AttributeDefinition.builder((String)"stringArray", (Object)new String[0]).build();
        Attribute stringArray = new Attribute(stringArrayDef);
        stringArray.fromString("a b c");
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])((Object[])stringArray.get()));
        stringArray.fromString("d");
        Assert.assertArrayEquals((Object[])new String[]{"d"}, (Object[])((Object[])stringArray.get()));
        stringArray.fromString("");
        Assert.assertArrayEquals((Object[])new String[0], (Object[])((Object[])stringArray.get()));
    }

    static class Holder<T> {
        T object;

        Holder(T object) {
            this.object = object;
        }

        Holder() {
            this.object = null;
        }

        T get() {
            return this.object;
        }

        void set(T object) {
            this.object = object;
        }
    }
}

