/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.stat;

import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.TimerTracker;

public class SimpleTimerTracker
implements TimerTracker {
    private final LongAdder counter = new LongAdder();
    private final DoubleAdder totalTime = new DoubleAdder();

    @Override
    public void update(Duration duration) {
        this.update(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public void update(long value, TimeUnit timeUnit) {
        this.counter.increment();
        this.totalTime.add(TimeUtils.convert((double)value, (TimeUnit)timeUnit, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    @Override
    public long count() {
        return this.counter.sum();
    }

    public double totalTime() {
        return this.totalTime.sum();
    }
}

