/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.TimeQuantity;
import org.junit.Assert;
import org.junit.Test;

public class TimeQuantityParserTest {
    @Test
    public void testParse() {
        this.assertIllegal("");
        this.assertIllegal("1.23.5");
        this.assertIllegal("1,23");
        this.assertIllegal("10.2");
        Assert.assertEquals((long)0L, (long)TimeQuantity.valueOf((String)"0").longValue());
        Assert.assertEquals((long)1000L, (long)TimeQuantity.valueOf((String)"1000ms").longValue());
        Assert.assertEquals((long)2000L, (long)TimeQuantity.valueOf((String)"2000 ms").longValue());
        Assert.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)TimeQuantity.valueOf((String)"1h").longValue());
        Assert.assertEquals((long)TimeUnit.HOURS.toMillis(2L), (long)TimeQuantity.valueOf((String)"2 h").longValue());
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)TimeQuantity.valueOf((String)"1m").longValue());
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(2L), (long)TimeQuantity.valueOf((String)"2 m").longValue());
        Assert.assertEquals((long)TimeUnit.SECONDS.toMillis(1L), (long)TimeQuantity.valueOf((String)"1s").longValue());
        Assert.assertEquals((long)TimeUnit.SECONDS.toMillis(2L), (long)TimeQuantity.valueOf((String)"2 s").longValue());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(1L), (long)TimeQuantity.valueOf((String)"1d").longValue());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(2L), (long)TimeQuantity.valueOf((String)"2 d").longValue());
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(210L), (long)TimeQuantity.valueOf((String)"3.5 h").longValue());
    }

    private void assertIllegal(String text) {
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeQuantity.valueOf((String)text));
    }
}

