/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.yaml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.yaml.YamlConfigurationReader;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Version;
import org.junit.Assert;
import org.junit.Test;

public class YamlConfigurationReaderTest {
    public static final String DEFAULT_NAMESPACE = "urn:infinispan:config:" + Version.getSchemaVersion();

    @Test
    public void testLine() {
        YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)new StringReader(""), (ConfigurationResourceResolver)new URLConfigurationResourceResolver(null), new Properties(), PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
        YamlConfigurationReader.Parsed p = yaml.parseLine("    key: value");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("'key': 'value'");
        Assert.assertEquals((long)0L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("    key: value    ");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("  key:");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  key: # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  key: value # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("  # Comment");
        Assert.assertEquals((long)2L, (long)p.indent);
        Assert.assertNull((Object)p.name);
        Assert.assertNull((Object)p.value);
        p = yaml.parseLine("  - value");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertTrue((boolean)p.list);
        Assert.assertNull((Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        p = yaml.parseLine("  - key: value");
        Assert.assertEquals((long)4L, (long)p.indent);
        Assert.assertTrue((boolean)p.list);
        Assert.assertEquals((Object)"key", (Object)p.name);
        Assert.assertEquals((Object)"value", (Object)p.value);
        Assert.assertNull((Object)yaml.parseLine((String)"key: ~").value);
        Assert.assertNull((Object)yaml.parseLine((String)"key: {}").value);
        Assert.assertNull((Object)yaml.parseLine((String)"key: null").value);
        Assert.assertNull((Object)yaml.parseLine((String)"key: Null").value);
        Assert.assertNull((Object)yaml.parseLine((String)"key: NULL").value);
        Assert.assertEquals((Object)"null", (Object)yaml.parseLine((String)"key: \"null\"").value);
        Assert.assertEquals((Object)"nullAndSome", (Object)yaml.parseLine((String)"key: \"nullAndSome\"").value);
        Assert.assertEquals((Object)"Null", (Object)yaml.parseLine((String)"key: \"Null\"").value);
        Assert.assertEquals((Object)"NULL", (Object)yaml.parseLine((String)"key: \"NULL\"").value);
        Assert.assertEquals((Object)"NUll", (Object)yaml.parseLine((String)"key: NUll").value);
        Exceptions.expectException(ConfigurationReaderException.class, () -> yaml.parseLine("  key # comment"));
    }

    @Test
    public void testYamlFile() throws IOException {
        URL url = YamlConfigurationReaderTest.class.getResource("/yaml.yaml");
        try (InputStreamReader r = new InputStreamReader(url.openStream());){
            Properties properties = new Properties();
            properties.put("opinion", "YAML is awful");
            properties.put("fact", "YAML is really awful");
            YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)r, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), properties, PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
            yaml.require(ConfigurationReader.ElementType.START_DOCUMENT);
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item1");
            Assert.assertEquals((long)4L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "item5", "v5");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "item6", "v6");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "item10", "some idiot thought this was a good idea");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "item12", "a string with \"escapes\" and more");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item2");
            Assert.assertEquals((long)4L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "a", "1");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "b", "2");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "c", "3");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "d", "4");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            Assert.assertEquals((Object)"camel-attribute", (Object)yaml.getAttributeName(0));
            Assert.assertEquals((Object)"YAML is awful", (Object)yaml.getAttributeValue(0));
            Assert.assertEquals((Object)"another-camel-attribute", (Object)yaml.getAttributeName(1));
            Assert.assertEquals((Object)"YAML is really awful", (Object)yaml.getAttributeValue(1));
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item2");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item7");
            Assert.assertEquals((Object)"v7", (Object)yaml.getElementText());
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item7");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item7");
            Assert.assertEquals((Object)"v8", (Object)yaml.getElementText());
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item7");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item8");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item8");
            Assert.assertEquals((long)2L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "a", "1");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "b", "2");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item8");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item8");
            Assert.assertEquals((long)2L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "a", "3");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "b", "4");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item8");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item8");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item9");
            Assert.assertEquals((long)2L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "a", "true");
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "b", "1 2 3 ");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "c");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "c");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item9");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item11");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item11");
            Assert.assertEquals((long)1L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "e", "3");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "a");
            Assert.assertEquals((long)1L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "b", "1");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "a");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "c");
            Assert.assertEquals((long)1L, (long)yaml.getAttributeCount());
            YamlConfigurationReaderTest.assertAttribute((ConfigurationReader)yaml, "d", "2");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "c");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item11");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item11");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item1");
            yaml.nextElement();
            yaml.require(ConfigurationReader.ElementType.END_DOCUMENT);
        }
    }

    public static void assertAttribute(ConfigurationReader reader, String name, String value) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!name.equals(reader.getAttributeName(i))) continue;
            Assert.assertEquals((Object)value, (Object)reader.getAttributeValue(i));
            return;
        }
        Assert.fail((String)("Could not find attribute '" + name + " in element '" + reader.getLocalName() + "'"));
    }

    @Test
    public void testYamlMapper() throws IOException {
        URL url = YamlConfigurationReaderTest.class.getResource("/identities.yaml");
        try (InputStreamReader r = new InputStreamReader(url.openStream());){
            YamlConfigurationReader yaml = new YamlConfigurationReader((Reader)r, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(url), new Properties(), PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
            Map identities = yaml.asMap();
            Assert.assertEquals((long)1L, (long)identities.size());
            List credentials = (List)identities.get("credentials");
            Assert.assertNotNull((Object)credentials);
            Assert.assertEquals((long)3L, (long)credentials.size());
            for (Object o : credentials) {
                Map credential = (Map)o;
                Assert.assertTrue((boolean)credential.containsKey("username"));
                Assert.assertTrue((boolean)credential.containsKey("password"));
                Assert.assertEquals((Object)"changeme", credential.get("password"));
                if ("my-user-1".equals(credential.get("username"))) {
                    Assert.assertTrue((boolean)credential.containsKey("roles"));
                    Assert.assertEquals(Collections.singletonList("admin"), credential.get("roles"));
                    continue;
                }
                if ("my-user-2".equals(credential.get("username"))) {
                    Assert.assertTrue((boolean)credential.containsKey("roles"));
                    Assert.assertEquals(Arrays.asList("monitor", "writer"), credential.get("roles"));
                    continue;
                }
                Assert.assertEquals((Object)"admin", credential.get("username"));
                Assert.assertFalse((boolean)credential.containsKey("roles"));
            }
        }
    }
}

