/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void propertyCouldNotBeReplaced(String line) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.propertyCouldNotBeReplaced$str(), (Object)line);
    }

    protected String propertyCouldNotBeReplaced$str() {
        return "ISPN000901: Property %s could not be replaced as intended!";
    }

    @Override
    public final void ignoringException(String methodName, String exceptionName, Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.ignoringException$str(), (Object)methodName, (Object)exceptionName);
    }

    protected String ignoringException$str() {
        return "ISPN000902: Invocation of %s threw an exception %s. Exception is ignored.";
    }

    protected String sslInitializationException$str() {
        return "ISPN000904: Error while initializing SSL context";
    }

    @Override
    public final CacheConfigurationException sslInitializationException(Throwable e) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.sslInitializationException$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void unableToLoadClass(String classname, String classloaders, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToLoadClass$str(), (Object)classname, (Object)classloaders);
    }

    protected String unableToLoadClass$str() {
        return "ISPN000905: Unable to load %s from any of the following classloaders: %s";
    }

    @Override
    public final void unableToConvertStringPropertyToInt(String value, int defaultValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToInt$str(), (Object)value, (Object)defaultValue);
    }

    protected String unableToConvertStringPropertyToInt$str() {
        return "ISPN000906: Unable to convert string property [%s] to an int! Using default value of %d";
    }

    @Override
    public final void unableToConvertStringPropertyToLong(String value, long defaultValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToLong$str(), (Object)value, (Object)defaultValue);
    }

    protected String unableToConvertStringPropertyToLong$str() {
        return "ISPN000907: Unable to convert string property [%s] to a long! Using default value of %d";
    }

    @Override
    public final void unableToConvertStringPropertyToBoolean(String value, boolean defaultValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToBoolean$str(), (Object)value, (Object)defaultValue);
    }

    protected String unableToConvertStringPropertyToBoolean$str() {
        return "ISPN000908: Unable to convert string property [%s] to a boolean! Using default value of %b";
    }

    protected String unableToUnwrap$str() {
        return "ISPN000909: Unwrapping %s to a type of %s is not a supported";
    }

    @Override
    public final IllegalArgumentException unableToUnwrap(Object o, Class<?> clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToUnwrap$str(), o, clazz));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalValueThreadPoolParameter$str() {
        return "ISPN000910: Illegal value for thread pool parameter(s) %s, it should be: %s";
    }

    @Override
    public final CacheConfigurationException illegalValueThreadPoolParameter(String parameter, String requirement) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.illegalValueThreadPoolParameter$str(), parameter, requirement));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToUnwrapAny$str() {
        return "ISPN000911: Unwrapping of any instances in %s to a type of %s is not a supported";
    }

    @Override
    public final IllegalArgumentException unableToUnwrapAny(String objs, Class<?> clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToUnwrapAny$str(), objs, clazz));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unprotectedAttributeSet$str() {
        return "ISPN000912: Expecting a protected configuration for %s";
    }

    @Override
    public final IllegalStateException unprotectedAttributeSet(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unprotectedAttributeSet$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String protectedAttributeSet$str() {
        return "ISPN000913: Expecting an unprotected configuration for %s";
    }

    @Override
    public final IllegalStateException protectedAttributeSet(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.protectedAttributeSet$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeSetDuplicateAttribute$str() {
        return "ISPN000914: Duplicate attribute '%s' in attribute set '%s'";
    }

    @Override
    public final IllegalArgumentException attributeSetDuplicateAttribute(String name, String setName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.attributeSetDuplicateAttribute$str(), name, setName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchAttribute$str() {
        return "ISPN000915: No such attribute '%s' in attribute set '%s'";
    }

    @Override
    public final IllegalArgumentException noSuchAttribute(String name, String setName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSuchAttribute$str(), name, setName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noAttributeCopierForType$str() {
        return "ISPN000916: No attribute copier for type '%s'";
    }

    @Override
    public final IllegalArgumentException noAttributeCopierForType(Class<?> klass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAttributeCopierForType$str(), klass));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindResource$str() {
        return "ISPN000918: Cannot find resource '%s'";
    }

    @Override
    public final IOException cannotFindResource(String fileName) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.cannotFindResource$str(), fileName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multipleConfigurationValidationErrors$str() {
        return "ISPN000919: Multiple errors encountered while validating configuration";
    }

    @Override
    public final CacheConfigurationException multipleConfigurationValidationErrors() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.multipleConfigurationValidationErrors$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToLoadFileUsingScheme$str() {
        return "ISPN000920: Unable to load file using scheme %s";
    }

    @Override
    public final UnsupportedOperationException unableToLoadFileUsingScheme(String scheme) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unableToLoadFileUsingScheme$str(), scheme));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchAliasInKeyStore$str() {
        return "ISPN000921: The alias '%s' does not exist in the key store '%s'";
    }

    @Override
    public final SecurityException noSuchAliasInKeyStore(String keyAlias, String keyStoreFileName) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.noSuchAliasInKeyStore$str(), keyAlias, keyStoreFileName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorRollingBack(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorRollingBack$str(), new Object[0]);
    }

    protected String errorRollingBack$str() {
        return "ISPN000922: Exception during rollback";
    }

    @Override
    public final void errorEnlistingResource(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorEnlistingResource$str(), new Object[0]);
    }

    protected String errorEnlistingResource$str() {
        return "ISPN000923: Error enlisting resource";
    }

    @Override
    public final void beforeCompletionFailed(String synchronization, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.beforeCompletionFailed$str(), (Object)synchronization);
    }

    protected String beforeCompletionFailed$str() {
        return "ISPN000924: beforeCompletion() failed for %s";
    }

    @Override
    public final void unexpectedErrorFromResourceManager(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.unexpectedErrorFromResourceManager$str(), new Object[0]);
    }

    protected String unexpectedErrorFromResourceManager$str() {
        return "ISPN000925: Unexpected error from resource manager!";
    }

    @Override
    public final void afterCompletionFailed(String synchronization, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.afterCompletionFailed$str(), (Object)synchronization);
    }

    protected String afterCompletionFailed$str() {
        return "ISPN000926: afterCompletion() failed for %s";
    }

    @Override
    public final void errorCommittingTx(Throwable e) {
        this.log.logf(FQCN, Logger.Level.WARN, e, this.errorCommittingTx$str(), new Object[0]);
    }

    protected String errorCommittingTx$str() {
        return "ISPN000927: exception while committing";
    }

    @Override
    public final void xaResourceEndFailed(String xaResource, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.xaResourceEndFailed$str(), (Object)xaResource);
    }

    protected String xaResourceEndFailed$str() {
        return "ISPN000928: end() failed for %s";
    }

    protected String missingMediaType$str() {
        return "ISPN000929: Media type cannot be empty or null!";
    }

    @Override
    public final EncodingException missingMediaType() {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.missingMediaType$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMediaTypeSubtype$str() {
        return "ISPN000930: Invalid media type '%s': must contain a type and a subtype separated by '/'";
    }

    @Override
    public final EncodingException invalidMediaTypeSubtype(String mediaType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidMediaTypeSubtype$str(), mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMediaTypeParam$str() {
        return "ISPN000931: Invalid media type '%s': invalid param '%s'";
    }

    @Override
    public final EncodingException invalidMediaTypeParam(String mediaType, String param) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidMediaTypeParam$str(), mediaType, param));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMediaTypeListCommaAtEnd$str() {
        return "ISPN000933: Invalid media type list '%s': type expected after comma";
    }

    @Override
    public final EncodingException invalidMediaTypeListCommaAtEnd(String mediaType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidMediaTypeListCommaAtEnd$str(), mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorTranscoding$str() {
        return "ISPN000934: Errors converting '%s' from '%s' to '%s'";
    }

    @Override
    public final EncodingException errorTranscoding(String content, MediaType contentType, MediaType requestType, Throwable t) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorTranscoding$str(), content, contentType, requestType), t);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWeight$str() {
        return "ISPN000935: Invalid Weight '%s'. Supported values are between 0 and 1.0";
    }

    @Override
    public final EncodingException invalidWeight(Object weight) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidWeight$str(), weight));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String classNotInAllowList$str() {
        return "ISPN000936: Class '%s' blocked by deserialization allow list. Adjust the configuration serialization allow list regular expression to include this class.";
    }

    @Override
    public final CacheException classNotInAllowList(String className) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.classNotInAllowList$str(), className));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidMediaType$str() {
        return "ISPN000937: Invalid media type. Expected '%s' but got '%s'";
    }

    @Override
    public final EncodingException invalidMediaType(String expected, String actual) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidMediaType$str(), expected, actual));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTextContent$str() {
        return "ISPN000938: Invalid text content '%s'";
    }

    @Override
    public final EncodingException invalidTextContent(Object content) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.invalidTextContent$str(), content));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conversionNotSupported$str() {
        return "ISPN000939: Conversion of content '%s' from '%s' to '%s' not supported";
    }

    @Override
    public final EncodingException conversionNotSupported(Object content, String fromMediaType, String toMediaType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.conversionNotSupported$str(), content, fromMediaType, toMediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotDecodeFormURLContent$str() {
        return "ISPN000940: Invalid application/x-www-form-urlencoded content: '%s'";
    }

    @Override
    public final EncodingException cannotDecodeFormURLContent(Object content) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.cannotDecodeFormURLContent$str(), content));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorEncoding$str() {
        return "ISPN000941: Error encoding content '%s' to '%s'";
    }

    @Override
    public final EncodingException errorEncoding(Object content, MediaType mediaType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.errorEncoding$str(), content, mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void unableToConvertStringPropertyToEnum(String value, String defaultValue) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unableToConvertStringPropertyToEnum$str(), (Object)value, (Object)defaultValue);
    }

    protected String unableToConvertStringPropertyToEnum$str() {
        return "ISPN000942: Unable to convert property [%s] to an enum! Using default value of %d";
    }

    protected String featureDisabled$str() {
        return "ISPN000944: Feature %s is disabled!";
    }

    @Override
    public final CacheConfigurationException featureDisabled(String feature) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.featureDisabled$str(), feature));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedConversion3$str() {
        return "ISPN000948: Unsupported conversion of '%s' from '%s' to '%s'";
    }

    @Override
    public final EncodingException unsupportedConversion(String content, MediaType contentType, MediaType requestType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.unsupportedConversion3$str(), content, contentType, requestType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedConversion2$str() {
        return "ISPN000949: Unsupported conversion of '%s' to '%s'";
    }

    @Override
    public final EncodingException unsupportedConversion(String content, MediaType requestType) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.unsupportedConversion2$str(), content, requestType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encodingNotSupported$str() {
        return "ISPN000950: Encoding '%s' is not supported";
    }

    @Override
    public final EncodingException encodingNotSupported(String enc) {
        EncodingException result = new EncodingException(String.format(this.getLoggingLocale(), this.encodingNotSupported$str(), enc));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String attributeMustBeGreaterThanZero$str() {
        return "ISPN000951: Invalid value %s for attribute %s: must be a number greater than zero";
    }

    @Override
    public final CacheConfigurationException attributeMustBeGreaterThanZero(Number value, Enum<?> attribute) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.attributeMustBeGreaterThanZero$str(), value, attribute));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void telemetryLoaded(Object telemetry) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.telemetryLoaded$str(), telemetry);
    }

    protected String telemetryLoaded$str() {
        return "ISPN000952: OpenTelemetry tracing instance loaded: %s";
    }

    @Override
    public final void errorOnLoadingTelemetry(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.errorOnLoadingTelemetry$str(), new Object[0]);
    }

    protected String errorOnLoadingTelemetry$str() {
        return "ISPN000954: OpenTelemetry tracing cannot be configured.";
    }

    protected String illegalBooleanValue$str() {
        return "ISPN000955: '%s' is not a valid boolean value (true|false|yes|no|y|n|on|off)";
    }

    @Override
    public final IllegalArgumentException illegalBooleanValue(String value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalBooleanValue$str(), value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalEnumValue$str() {
        return "ISPN000956: '%s' is not one of %s";
    }

    @Override
    public final IllegalArgumentException illegalEnumValue(String value, EnumSet<?> set) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalEnumValue$str(), value, set));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cannotLoadMimeTypes(String mimeTypes) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.cannotLoadMimeTypes$str(), (Object)mimeTypes);
    }

    protected String cannotLoadMimeTypes$str() {
        return "ISPN000957: Cannot load %s";
    }

    protected String cannotParseQuantity$str() {
        return "ISPN000958: Cannot parse bytes quantity %s";
    }

    @Override
    public final IllegalArgumentException cannotParseQuantity(String str) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotParseQuantity$str(), str));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void deprecatedProperty(String oldName, String newName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.deprecatedProperty$str(), (Object)oldName, (Object)newName);
    }

    protected String deprecatedProperty$str() {
        return "ISPN000959: Property '%s' has been deprecated. Please use '%s' instead.";
    }

    protected String noAttribute$str() {
        return "ISPN000960: No attribute '%s' in '%s'";
    }

    @Override
    public final IllegalArgumentException noAttribute(String name, String element) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noAttribute$str(), name, element));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleAttribute$str() {
        return "ISPN000961: Incompatible attribute '%s.%s' existing value='%s', new value='%s'";
    }

    @Override
    public final IllegalArgumentException incompatibleAttribute(String parentName, String name, String v1, String v2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incompatibleAttribute$str(), parentName, name, v1, v2));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String protectedAttribute$str() {
        return "ISPN000962: Cannot modify protected attribute '%s'";
    }

    @Override
    public final IllegalStateException protectedAttribute(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.protectedAttribute$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidConfiguration$str() {
        return "ISPN000963: Invalid configuration in '%s'";
    }

    @Override
    public final IllegalArgumentException invalidConfiguration(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidConfiguration$str(), name));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String respCacheKeyMediaTypeSupplied$str() {
        return "ISPN000964: RESP cache '%s' key media type must be configured as application/octet-stream but was %s";
    }

    @Override
    public final IllegalArgumentException respCacheKeyMediaTypeSupplied(String cacheName, MediaType mediaType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.respCacheKeyMediaTypeSupplied$str(), cacheName, mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String respCacheSegmentSizePow2$str() {
        return "ISPN000965: Relation between segment and slots only for power 2, received: %s";
    }

    @Override
    public final IllegalArgumentException respCacheSegmentSizePow2(int configured) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.respCacheSegmentSizePow2$str(), configured));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String respCacheUseDefineConsistentHash$str() {
        return "ISPN000966: RESP cache '%s' should use RESPHashFunctionPartitioner but is using %s";
    }

    @Override
    public final IllegalArgumentException respCacheUseDefineConsistentHash(String cacheName, String configured) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.respCacheUseDefineConsistentHash$str(), cacheName, configured));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String errorOnParsingPrometheusURLForTracing$str() {
        return "ISPN000967: Cannot parse Prometheus URL for tracing.'";
    }

    @Override
    public final CacheConfigurationException errorOnParsingPrometheusURLForTracing(Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.errorOnParsingPrometheusURLForTracing$str(), new Object[0]), t);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToCreateInitialCtx(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.failedToCreateInitialCtx$str(), new Object[0]);
    }

    protected String failedToCreateInitialCtx$str() {
        return "ISPN000968: Failed creating initial JNDI context";
    }

    protected String certificateReloadError$str() {
        return "ISPN000970: Error while reloading certificate";
    }

    @Override
    public final RuntimeException certificateReloadError(Exception ex) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.certificateReloadError$str(), new Object[0]), ex);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateClass$str() {
        return "ISPN029523: Cannot instantiate class '%s'";
    }

    @Override
    public final CacheConfigurationException cannotInstantiateClass(String classname, Throwable t) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.cannotInstantiateClass$str(), classname));
        Log_$logger._copyStackTraceMinusOne(result);
        result.addSuppressed(t);
        return result;
    }
}

