/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.Location;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.configuration.io.PropertyReplacer;
import org.infinispan.commons.configuration.io.URLConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.json.JsonConfigurationReader;
import org.infinispan.commons.util.Version;
import org.junit.Assert;
import org.junit.Test;

public class JsonConfigurationReaderTest {
    public static final String DEFAULT_NAMESPACE = "urn:infinispan:config:" + Version.getSchemaVersion();

    @Test
    public void testJsonFile() throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(JsonConfigurationReaderTest.class.getResourceAsStream("/json.json")));){
            Properties properties = new Properties();
            properties.put("opinion", "JSON is pretty nice");
            properties.put("fact", "JSON is ok");
            JsonConfigurationReader json = new JsonConfigurationReader(r, (ConfigurationResourceResolver)new URLConfigurationResourceResolver(null), properties, PropertyReplacer.DEFAULT, NamingStrategy.KEBAB_CASE);
            json.require(ConfigurationReader.ElementType.START_DOCUMENT);
            json.nextElement();
            json.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item1");
            this.assertLocation(json, 3, 5);
            Assert.assertEquals((long)3L, (long)json.getAttributeCount());
            this.assertAttribute(json, "item5", "v5");
            this.assertAttribute(json, "item6", "v6");
            this.assertAttribute(json, "item7", new String[]{"v7", "v8"});
            json.nextElement();
            json.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "item2");
            this.assertLocation(json, 4, 7);
            Assert.assertEquals((long)4L, (long)json.getAttributeCount());
            this.assertAttribute(json, "a", "1");
            this.assertAttribute(json, "b", "2");
            this.assertAttribute(json, "c", "3");
            this.assertAttribute(json, "d", "4");
            json.nextElement();
            json.require(ConfigurationReader.ElementType.START_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            this.assertLocation(json, 8, 9);
            Assert.assertEquals((Object)"camel-attribute", (Object)json.getAttributeName(0));
            Assert.assertEquals((Object)properties.getProperty("opinion"), (Object)json.getAttributeValue(0));
            Assert.assertEquals((Object)"another-camel-attribute", (Object)json.getAttributeName(1));
            Assert.assertEquals((Object)properties.getProperty("fact"), (Object)json.getAttributeValue(1));
            json.nextElement();
            json.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "camel-item3");
            json.nextElement();
            json.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item2");
            json.nextElement();
            json.require(ConfigurationReader.ElementType.END_ELEMENT, DEFAULT_NAMESPACE, "item1");
            json.nextElement();
            json.require(ConfigurationReader.ElementType.END_DOCUMENT);
        }
    }

    private void assertLocation(JsonConfigurationReader json, int line, int col) {
        Location location = json.getLocation();
        Assert.assertEquals((String)"Line", (long)line, (long)location.getLineNumber());
        Assert.assertEquals((String)"Column", (long)col, (long)location.getColumnNumber());
        System.out.println(location);
    }

    private void assertAttribute(JsonConfigurationReader json, String name, String value) {
        for (int i = 0; i < json.getAttributeCount(); ++i) {
            if (!name.equals(json.getAttributeName(i))) continue;
            Assert.assertEquals((Object)value, (Object)json.getAttributeValue(i));
            return;
        }
        Assert.fail((String)("Could not find attribute '" + name + " in element '" + json.getLocalName() + "'"));
    }

    private void assertAttribute(JsonConfigurationReader json, String name, String[] value) {
        for (int i = 0; i < json.getAttributeCount(); ++i) {
            if (!name.equals(json.getAttributeName(i))) continue;
            Assert.assertArrayEquals((Object[])value, (Object[])json.getListAttributeValue(i));
            return;
        }
        Assert.fail((String)("Could not find attribute '" + name + " in element '" + json.getLocalName() + "'"));
    }
}

