/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.logging.log4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Patterns;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderException;
import org.infinispan.commons.dataconversion.MediaType;

public class XmlConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final List<Status> status = new ArrayList<Status>();

    public XmlConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
        super(loggerContext, configSource);
    }

    private void parseConfiguration(ConfigurationReader reader) {
        StatusConfiguration statusConfig = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
        int monitorIntervalSeconds = 0;
        block25: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            switch (reader.getAttributeName(i).toLowerCase()) {
                case "status": {
                    statusConfig.withStatus(value);
                    continue block25;
                }
                case "dest": {
                    statusConfig.withDestination(value);
                    continue block25;
                }
                case "shutdownhook": {
                    this.isShutdownHookEnabled = !"disable".equals(value);
                    continue block25;
                }
                case "shutdowntimeout": {
                    this.shutdownTimeoutMillis = Long.parseLong(value);
                    continue block25;
                }
                case "verbose": {
                    statusConfig.withVerbosity(value);
                    continue block25;
                }
                case "packages": {
                    this.pluginPackages.addAll(Arrays.asList(value.split(Patterns.COMMA_SEPARATOR)));
                    continue block25;
                }
                case "name": {
                    this.setName(value);
                    continue block25;
                }
                case "strict": 
                case "schema": {
                    continue block25;
                }
                case "monitorinterval": {
                    monitorIntervalSeconds = Integer.parseInt(value);
                    continue block25;
                }
                case "advertiser": {
                    continue block25;
                }
                default: {
                    throw new ConfigurationReaderException("Unexpected attribute '" + reader.getAttributeName(i) + "' encountered", reader.getLocation());
                }
            }
        }
        this.initializeWatchers(this, this.getConfigurationSource(), monitorIntervalSeconds);
        statusConfig.initialize();
        if (this.getName() == null) {
            this.setName(this.getConfigurationSource().getLocation());
        }
        this.parseElement(reader, this.rootNode);
    }

    public void setup() {
        File configFile = this.getConfigurationSource().getFile();
        try (InputStream configStream = Files.newInputStream(configFile.toPath(), new OpenOption[0]);){
            ConfigurationReader reader = ConfigurationReader.from(configStream).withProperties(System.getProperties()).withReplacer((string, props) -> this.getStrSubstitutor().replace(string)).withType(MediaType.APPLICATION_XML).build();
            reader.require(ConfigurationReader.ElementType.START_DOCUMENT);
            reader.nextElement();
            reader.require(ConfigurationReader.ElementType.START_ELEMENT, null, "Configuration");
            this.parseConfiguration(reader);
            while (reader.nextElement() != ConfigurationReader.ElementType.END_DOCUMENT) {
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationException(e);
        }
        if (!this.status.isEmpty()) {
            for (Status s : this.status) {
                LOGGER.error("Error processing element {} ({}): {}", (Object)s.name, (Object)s.element, (Object)s.errorType);
            }
            return;
        }
    }

    public Configuration reconfigure() {
        try {
            ConfigurationSource source = this.getConfigurationSource().resetInputStream();
            if (source == null) {
                return null;
            }
            return new XmlConfiguration(this.getLoggerContext(), source);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)ex);
            return null;
        }
    }

    private void parseElement(ConfigurationReader reader, Node node) {
        this.processAttributes(reader, node);
        List children = node.getChildren();
        block6: while (reader.inTag()) {
            String name = reader.getLocalName();
            PluginType type = this.pluginManager.getPluginType(name);
            Node childNode = new Node(node, name, type);
            switch (name.toLowerCase()) {
                case "property": {
                    this.processAttributes(reader, childNode);
                    childNode.setValue(reader.getElementText().trim());
                    children.add(childNode);
                    continue block6;
                }
            }
            this.parseElement(reader, childNode);
            if (type == null) {
                String value = childNode.getValue();
                if (!childNode.hasChildren() && value != null) {
                    node.getAttributes().put(name, value);
                    continue;
                }
                this.status.add(new Status(name, name, ErrorType.CLASS_NOT_FOUND));
                continue;
            }
            children.add(childNode);
        }
    }

    private void processAttributes(ConfigurationReader reader, Node node) {
        Map attributes = node.getAttributes();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            attributes.put(reader.getAttributeName(i), reader.getAttributeValue(i));
        }
    }

    private static class Status {
        private final String element;
        private final String name;
        private final ErrorType errorType;

        public Status(String name, String element, ErrorType errorType) {
            this.name = name;
            this.element = element;
            this.errorType = errorType;
        }

        public String toString() {
            return "Status [name=" + this.name + ", element=" + this.element + ", errorType=" + String.valueOf((Object)this.errorType) + "]";
        }
    }

    private static enum ErrorType {
        CLASS_NOT_FOUND;

    }
}

