/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeParser;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeValidator;

public final class AttributeDefinition<T> {
    private final String name;
    private final T defaultValue;
    private final boolean immutable;
    private final boolean autoPersist;
    private final boolean global;
    private final AttributeCopier<T> copier;
    private final AttributeInitializer<? extends T> initializer;
    private final AttributeValidator<? super T> validator;
    private final AttributeSerializer<? super T> serializer;
    private final AttributeParser<? super T> parser;
    private final Class<T> type;
    private final int deprecatedMajor;
    private final int deprecatedMinor;

    AttributeDefinition(String name, T initialValue, Class<T> type, boolean immutable, boolean autoPersist, boolean global, AttributeCopier<T> copier, AttributeValidator<? super T> validator, AttributeInitializer<? extends T> initializer, AttributeSerializer<? super T> serializer, AttributeParser<? super T> parser, int deprecatedMajor, int deprecatedMinor) {
        this.name = name;
        this.defaultValue = initialValue;
        this.immutable = immutable;
        this.autoPersist = autoPersist;
        this.global = global;
        this.copier = copier;
        this.initializer = initializer;
        this.validator = validator;
        this.serializer = serializer;
        this.parser = parser;
        this.type = type;
        this.deprecatedMajor = deprecatedMajor;
        this.deprecatedMinor = deprecatedMinor;
    }

    public String name() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.initializer != null ? this.initializer().initialize() : this.defaultValue;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAutoPersist() {
        return this.autoPersist;
    }

    public boolean isRepeated() {
        return this.type.isArray() || Collection.class.isAssignableFrom(this.type);
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isDeprecated(int major, int minor) {
        return major > this.deprecatedMajor || major == this.deprecatedMajor && minor > this.deprecatedMinor;
    }

    public AttributeCopier<T> copier() {
        return this.copier;
    }

    public AttributeInitializer<? extends T> initializer() {
        return this.initializer;
    }

    AttributeValidator<? super T> validator() {
        return this.validator;
    }

    public AttributeSerializer<? super T> serializer() {
        return this.serializer;
    }

    public T parse(String value) {
        return this.parser.parse(this.type, value);
    }

    public Attribute<T> toAttribute() {
        return new Attribute(this);
    }

    public void validate(T value) {
        if (this.validator != null) {
            this.validator.validate(value);
        }
    }

    public static <T> Builder<T> builder(Enum<?> name, T defaultValue) {
        return AttributeDefinition.builder(name.toString(), defaultValue);
    }

    public static <T> Builder<T> builder(String name, T defaultValue) {
        if (defaultValue != null) {
            return new Builder<T>(name, defaultValue, defaultValue.getClass());
        }
        throw new CacheConfigurationException("Must specify type when passing null for AttributeDefinition " + name);
    }

    public static <T> Builder<T> builder(Enum<?> name, T defaultValue, Class<T> klass) {
        return new Builder<T>(name.toString(), defaultValue, klass);
    }

    public static <T> Builder<T> builder(String name, T defaultValue, Class<T> klass) {
        return new Builder<T>(name, defaultValue, klass);
    }

    public static <T> Builder<Class<? extends T>> classBuilder(String name, Class<T> klass) {
        return new Builder<Class<? extends T>>(name, null, Class.class);
    }

    public static <T> Builder<Supplier<? extends T>> supplierBuilder(String name, Class<T> klass) {
        return new Builder<Supplier<? extends T>>(name, null, Supplier.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        if (this.immutable != that.immutable) {
            return false;
        }
        if (this.autoPersist != that.autoPersist) {
            return false;
        }
        if (this.global != that.global) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, that.defaultValue)) {
            return false;
        }
        if (!Objects.equals(this.copier, that.copier)) {
            return false;
        }
        if (!Objects.equals(this.initializer, that.initializer)) {
            return false;
        }
        if (!Objects.equals(this.validator, that.validator)) {
            return false;
        }
        if (!Objects.equals(this.serializer, that.serializer)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.immutable ? 1 : 0);
        result = 31 * result + (this.autoPersist ? 1 : 0);
        result = 31 * result + (this.global ? 1 : 0);
        result = 31 * result + (this.copier != null ? this.copier.hashCode() : 0);
        result = 31 * result + (this.initializer != null ? this.initializer.hashCode() : 0);
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.serializer != null ? this.serializer.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private final String name;
        private final T defaultValue;
        private final Class<T> type;
        private boolean immutable = false;
        private boolean autoPersist = true;
        private boolean global = true;
        private AttributeCopier<T> copier = null;
        private AttributeInitializer<? extends T> initializer;
        private AttributeValidator<? super T> validator;
        private AttributeSerializer<? super T> serializer = AttributeSerializer.DEFAULT;
        private AttributeParser<? super T> parser = AttributeParser.DEFAULT;
        private int deprecatedMajor = Integer.MAX_VALUE;
        private int deprecatedMinor = Integer.MAX_VALUE;

        private Builder(String name, T defaultValue, Class<T> type) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public Builder<T> immutable() {
            this.immutable = true;
            return this;
        }

        public Builder<T> copier(AttributeCopier<T> copier) {
            this.copier = copier;
            return this;
        }

        public Builder<T> initializer(AttributeInitializer<? extends T> initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder<T> autoPersist(boolean autoPersist) {
            this.autoPersist = autoPersist;
            return this;
        }

        public Builder<T> global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder<T> validator(AttributeValidator<? super T> validator) {
            this.validator = validator;
            return this;
        }

        public Builder<T> serializer(AttributeSerializer<? super T> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder<T> parser(AttributeParser<? super T> parser) {
            this.parser = parser;
            return this;
        }

        public Builder<T> deprecatedSince(int major, int minor) {
            this.deprecatedMajor = major;
            this.deprecatedMinor = minor;
            return this;
        }

        public AttributeDefinition<T> build() {
            return new AttributeDefinition<T>(this.name, this.defaultValue, this.type, this.immutable, this.autoPersist, this.global, this.copier, this.validator, this.initializer, this.serializer, this.parser, this.deprecatedMajor, this.deprecatedMinor);
        }
    }
}

