/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.junit;

import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.rules.ExternalResource;

public class ClassResource<T>
extends ExternalResource {
    private static final Logger log = Logger.getLogger(ClassResource.class);
    private T resource;
    private Consumer<T> closer;

    public ClassResource() {
        this.closer = r -> {
            try {
                ((AutoCloseable)r).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public ClassResource(Consumer<T> closer) {
        this.closer = closer;
    }

    protected void after() {
        try {
            this.closer.accept(this.resource);
            this.resource = null;
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to close resource %s", this.resource);
        }
    }

    public T cache(ExceptionSupplier<T> supplier) throws Exception {
        if (this.resource != null) {
            return this.resource;
        }
        this.resource = supplier.get();
        if (!(this.resource instanceof AutoCloseable)) {
            throw new IllegalStateException("Resource does not implement AutoCloseable, please set up a custom closer in the constructor");
        }
        return this.resource;
    }

    public T get() {
        return this.resource;
    }

    public static interface ExceptionSupplier<T> {
        public T get() throws Exception;
    }
}

