/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

@Deprecated(forRemoval=true)
public class RangeSet
implements IntSet {
    final int size;

    public RangeSet(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        int i = (Integer)o;
        return this.contains(i);
    }

    @Override
    public boolean contains(int i) {
        return 0 <= i && i < this.size;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new RangeSetIterator(this.size);
    }

    @Override
    public int[] toIntArray() {
        int[] array = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public byte[] toBitSet() {
        if (this.size == 0) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        int offset = this.size >>> 3;
        if ((this.size & 0xF) == 0) {
            byte[] array = new byte[offset];
            Arrays.fill(array, (byte)-1);
            return array;
        }
        byte[] array = new byte[offset + 1];
        if (offset > 0) {
            Arrays.fill(array, 0, offset, (byte)-1);
        }
        int lastBitOffset = this.size > 8 ? this.size % 8 : this.size;
        array[offset] = (byte)(255 >> 8 - lastBitOffset);
        return array;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] array = a.length >= this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        for (int i = 0; i < this.size; ++i) {
            array[i] = i;
        }
        return array;
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean remove(int i) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof IntSet) {
            return this.containsAll((IntSet)c);
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(IntSet set) {
        if (set instanceof RangeSet) {
            return this.size >= ((RangeSet)set).size;
        }
        PrimitiveIterator.OfInt iter = set.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(int i) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public void set(int i) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean addAll(IntSet set) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean retainAll(IntSet c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean removeAll(IntSet set) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Set)) {
            return false;
        }
        if (o instanceof RangeSet) {
            RangeSet integers = (RangeSet)o;
            return this.size == integers.size;
        }
        Set set = (Set)o;
        return this.size == set.size() && this.containsAll(set);
    }

    @Override
    public IntStream intStream() {
        return IntStream.range(0, this.size);
    }

    @Override
    public void forEach(IntConsumer action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept(i);
        }
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept((Integer)i);
        }
    }

    @Override
    public Spliterator.OfInt intSpliterator() {
        return new RangeSetSpliterator(this.size);
    }

    @Override
    public boolean removeIf(IntPredicate filter) {
        throw new UnsupportedOperationException("RangeSet is immutable");
    }

    @Override
    public int hashCode() {
        return this.size;
    }

    public String toString() {
        return "RangeSet(" + this.size + ")";
    }

    private static class RangeSetIterator
    implements PrimitiveIterator.OfInt {
        private int size;
        private int next;

        public RangeSetIterator(int size) {
            this.size = size;
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.size;
        }

        @Override
        public int nextInt() {
            if (this.next >= this.size) {
                throw new NoSuchElementException();
            }
            return this.next++;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("RangeSet is read-only");
        }
    }

    private static class RangeSetSpliterator
    implements Spliterator.OfInt {
        private int next;
        private final int size;

        public RangeSetSpliterator(int size) {
            this.next = 0;
            this.size = size;
        }

        RangeSetSpliterator(int next, int size) {
            this.next = next;
            this.size = size;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            RangeSetSpliterator rangeSetSpliterator;
            int lo = this.next;
            int mid = lo + this.size >>> 1;
            if (lo >= mid) {
                rangeSetSpliterator = null;
            } else {
                this.next = mid;
                RangeSetSpliterator rangeSetSpliterator2 = new RangeSetSpliterator(lo, this.next);
                rangeSetSpliterator = rangeSetSpliterator2;
            }
            return rangeSetSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            while (this.next < this.size) {
                action.accept(this.next);
                ++this.next;
            }
        }

        @Override
        public long estimateSize() {
            return this.size - this.next;
        }

        @Override
        public int characteristics() {
            return 17749;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (this.next < this.size) {
                action.accept(this.next++);
                return true;
            }
            return false;
        }
    }
}

