/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.graalvm;

import java.nio.file.Path;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;

public class ClassLoaderFeatureAccess
implements Feature.FeatureAccess {
    private final ClassLoader cl;

    public ClassLoaderFeatureAccess(ClassLoader cl) {
        this.cl = cl;
    }

    public Class<?> findClassByName(String className) {
        try {
            return Class.forName(className, false, this.cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Path> getApplicationClassPath() {
        throw new IllegalStateException();
    }

    public List<Path> getApplicationModulePath() {
        throw new IllegalStateException();
    }

    public ClassLoader getApplicationClassLoader() {
        return this.cl;
    }
}

