/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.factory;

import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.listener.CounterManagerNotificationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.NONE)
public abstract class CacheBaseCounterFactory<K extends CounterKey> {
    @Inject
    BlockingManager blockingManager;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    CounterManagerNotificationManager notificationManager;

    protected CompletionStage<AdvancedCache<K, CounterValue>> cache(CounterConfiguration configuration) {
        return configuration.storage() == Storage.VOLATILE ? this.getCounterCacheAsync().thenApply(this::transformCacheToVolatile) : this.getCounterCacheAsync();
    }

    CompletionStage<AdvancedCache<K, CounterValue>> getCounterCacheAsync() {
        return this.blockingManager.supplyBlocking(this::getCounterCacheSync, (Object)"get-counter-cache");
    }

    private AdvancedCache<K, CounterValue> getCounterCacheSync() {
        Cache cache = this.cacheManager.getCache("org.infinispan.COUNTER");
        return cache.getAdvancedCache();
    }

    private AdvancedCache<K, CounterValue> transformCacheToVolatile(AdvancedCache<K, CounterValue> cache) {
        return cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE});
    }
}

