/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.util.concurrent.CompletionStages;

public final class Util {
    private Util() {
    }

    private static CounterException rethrowAsCounterException(Throwable throwable) {
        if (throwable instanceof CounterException) {
            return (CounterException)throwable;
        }
        if (throwable instanceof ExecutionException || throwable instanceof CompletionException) {
            return Util.rethrowAsCounterException(throwable.getCause());
        }
        return new CounterException(throwable);
    }

    public static <T> T awaitCounterOperation(CompletionStage<T> stage) {
        try {
            return (T)CompletionStages.await(stage);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Util.rethrowAsCounterException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw Util.rethrowAsCounterException(e.getCause());
        }
    }
}

