/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.StreamingRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.GetStreamOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamOperation;

public class StreamingRemoteCacheImpl<K>
implements StreamingRemoteCache<K> {
    private final RemoteCacheImpl<K, ?> cache;

    public StreamingRemoteCacheImpl(RemoteCacheImpl<K, ?> cache) {
        this.cache = cache;
    }

    @Override
    public <T extends InputStream> T get(K key) {
        GetStreamOperation op = this.cache.operationsFactory.newGetStreamOperation(this.cache.keyAsObjectIfNeeded(key), this.cache.keyToBytes(key), 0);
        return (T)((InputStream)Util.await(op.execute()));
    }

    @Override
    public OutputStream put(K key) {
        return this.put(key, -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream put(K key, long lifespan, TimeUnit unit) {
        return this.put(key, lifespan, unit, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream put(K key, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        PutStreamOperation op = this.cache.operationsFactory.newPutStreamOperation(this.cache.keyAsObjectIfNeeded(key), this.cache.keyToBytes(key), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        return (OutputStream)Util.await(op.execute());
    }

    @Override
    public OutputStream putIfAbsent(K key) {
        return this.putIfAbsent(key, -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream putIfAbsent(K key, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, lifespan, unit, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream putIfAbsent(K key, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        PutStreamOperation op = this.cache.operationsFactory.newPutIfAbsentStreamOperation(this.cache.keyAsObjectIfNeeded(key), this.cache.keyToBytes(key), lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        return (OutputStream)Util.await(op.execute());
    }

    @Override
    public OutputStream replaceWithVersion(K key, long version) {
        return this.replaceWithVersion(key, version, -1L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream replaceWithVersion(K key, long version, long lifespan, TimeUnit unit) {
        return this.replaceWithVersion(key, version, lifespan, unit, -1L, TimeUnit.SECONDS);
    }

    @Override
    public OutputStream replaceWithVersion(K key, long version, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        PutStreamOperation op = this.cache.operationsFactory.newPutStreamOperation(this.cache.keyAsObjectIfNeeded(key), this.cache.keyToBytes(key), version, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
        return (OutputStream)Util.await(op.execute());
    }
}

