/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.consistenthash.SegmentConsistentHash;
import org.infinispan.client.hotrod.impl.topology.CacheInfo;
import org.infinispan.client.hotrod.impl.topology.ClusterInfo;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;

@NotThreadSafe
public final class TopologyInfo {
    private static final Log log = LogFactory.getLog(TopologyInfo.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Supplier<FailoverRequestBalancingStrategy> balancerFactory;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private final ConcurrentMap<WrappedBytes, CacheInfo> caches = new ConcurrentHashMap<WrappedBytes, CacheInfo>();
    private volatile ClusterInfo cluster;
    private int topologyAge;

    public TopologyInfo(Configuration configuration, ClusterInfo clusterInfo) {
        this.balancerFactory = configuration.balancingStrategyFactory();
        this.hashFactory.init(configuration);
        this.topologyAge = 0;
        this.cluster = clusterInfo;
    }

    public List<InetSocketAddress> getServers(WrappedBytes cacheName) {
        return this.getCacheInfo(cacheName).getServers();
    }

    public Collection<InetSocketAddress> getAllServers() {
        return this.caches.values().stream().flatMap(ct -> ct.getServers().stream()).collect(Collectors.toSet());
    }

    public SegmentConsistentHash createConsistentHash(int numSegments, short hashFunctionVersion, SocketAddress[][] segmentOwners) {
        SegmentConsistentHash hash = null;
        if (hashFunctionVersion > 0) {
            hash = (SegmentConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(segmentOwners, numSegments);
            }
        }
        return hash;
    }

    public ConsistentHash createConsistentHash1x(Map<InetSocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace) {
        ConsistentHash hash = null;
        if (hashFunctionVersion > 0) {
            hash = (ConsistentHash)this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(servers2Hash, numKeyOwners, hashSpace);
            }
        }
        return hash;
    }

    private boolean isReplicated(Map<SocketAddress, Set<Integer>> ch) {
        if (ch.isEmpty()) {
            return false;
        }
        Set<Integer> first = ch.values().iterator().next();
        return ch.values().stream().allMatch(s -> s.equals(first));
    }

    public SocketAddress getHashAwareServer(Set<Integer> segments, byte[] cacheName) {
        ConsistentHash consistentHash;
        SocketAddress server = null;
        if (segments == null || segments.isEmpty()) {
            return server;
        }
        if (this.isTopologyValid(cacheName) && (consistentHash = ((CacheInfo)this.caches.get(new WrappedByteArray(cacheName))).getConsistentHash()) != null) {
            Map<SocketAddress, Set<Integer>> segmentsByServer = consistentHash.getSegmentsByServer();
            if (this.isReplicated(segmentsByServer)) {
                Integer firstSegment = segments.iterator().next();
                int index = firstSegment % segmentsByServer.size();
                SocketAddress replicatedServer = segmentsByServer.keySet().stream().skip(index).findFirst().orElse(null);
                if (trace) {
                    log.tracef("Remote cache is replicated, choosing server %s for segments %s", replicatedServer, segments);
                }
                return replicatedServer;
            }
            int segmentMax = segments.size();
            int currentMax = 0;
            SocketAddress socketAddressToUse = null;
            for (Map.Entry<SocketAddress, Set<Integer>> serverSegment : segmentsByServer.entrySet()) {
                int segmentOwnedCount = 0;
                for (Integer segment : serverSegment.getValue()) {
                    if (!segments.contains(segment)) continue;
                    ++segmentOwnedCount;
                }
                if (segmentOwnedCount == segmentMax) {
                    socketAddressToUse = serverSegment.getKey();
                    break;
                }
                if (segmentOwnedCount <= currentMax) continue;
                currentMax = segmentOwnedCount;
                socketAddressToUse = serverSegment.getKey();
            }
            if (socketAddressToUse != null) {
                server = socketAddressToUse;
            }
            if (trace) {
                log.tracef("Using consistent hash for determining the server: " + socketAddressToUse + " as it owns " + currentMax + " of the " + segmentMax + " provided segments.", new Object[0]);
            }
        }
        return server;
    }

    public boolean isTopologyValid(byte[] cacheName) {
        CacheInfo cacheInfo = (CacheInfo)this.caches.get(Util.wrapBytes(cacheName));
        return cacheInfo != null && cacheInfo.getTopologyId() != -2;
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        WrappedByteArray key = Util.wrapBytes(cacheName);
        return ((CacheInfo)this.caches.get(key)).getCacheTopologyInfo();
    }

    public CacheInfo getCacheInfo(WrappedBytes cacheName) {
        return (CacheInfo)this.caches.get(cacheName);
    }

    public CacheInfo getOrCreateCacheInfo(WrappedBytes cacheName) {
        return this.caches.computeIfAbsent(cacheName, cn -> {
            CacheInfo cacheInfo = new CacheInfo((WrappedBytes)cn, this.balancerFactory.get(), this.topologyAge, this.cluster.getInitialServers());
            cacheInfo.updateBalancerServers();
            if (log.isTraceEnabled()) {
                log.tracef("Creating cache info %s with topology age %d", cacheInfo.getCacheName(), this.topologyAge);
            }
            return cacheInfo;
        });
    }

    public void switchCluster(ClusterInfo newCluster) {
        if (log.isTraceEnabled()) {
            log.tracef("Switching cluster: %s -> %s", this.cluster.getName(), newCluster.getName());
        }
        this.caches.replaceAll((name, oldInfo) -> {
            CacheInfo newInfo = oldInfo.withNewServers(this.topologyAge + 1, -2, newCluster.getInitialServers());
            newInfo.updateBalancerServers();
            newInfo.getTopologyIdRef().set(-2);
            return newInfo;
        });
        this.cluster = newCluster;
        ++this.topologyAge;
    }

    public void reset(WrappedBytes cacheName) {
        if (log.isTraceEnabled()) {
            log.tracef("Switching to initial server list for cache %s, cluster %s", cacheName, this.cluster.getName());
        }
        this.caches.computeIfPresent(cacheName, (name, oldInfo) -> {
            CacheInfo newInfo = oldInfo.withNewServers(this.topologyAge, -1, this.cluster.getInitialServers());
            newInfo.updateBalancerServers();
            newInfo.getTopologyIdRef().set(newInfo.getTopologyId());
            return newInfo;
        });
    }

    public ClusterInfo getCluster() {
        return this.cluster;
    }

    public int getTopologyAge() {
        return this.topologyAge;
    }

    public void updateCacheInfo(WrappedBytes cacheName, CacheInfo oldCacheInfo, CacheInfo newCacheInfo) {
        if (log.isTraceEnabled()) {
            log.tracef("Updating topology for %s: %s -> %s", newCacheInfo.getCacheName(), oldCacheInfo.getTopologyId(), newCacheInfo.getTopologyId());
        }
        CacheInfo existing = this.caches.put(cacheName, newCacheInfo);
        assert (existing == oldCacheInfo) : "Locking should have prevented concurrent updates";
        newCacheInfo.updateBalancerServers();
    }

    public void forEachCache(BiConsumer<WrappedBytes, CacheInfo> action) {
        this.caches.forEach(action);
    }
}

