/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.BaseQueryResponse;
import org.infinispan.query.remote.client.JsonClientQueryResponse;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;

enum QuerySerializer {
    JSON(MediaType.APPLICATION_JSON){
        private final Gson mapper = new GsonBuilder().disableHtmlEscaping().create();

        @Override
        byte[] serializeQueryRequest(RemoteQuery remoteQuery, QueryRequest queryRequest) {
            JsonObject object = this.mapper.toJsonTree((Object)queryRequest).getAsJsonObject();
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }

        JsonClientQueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery remoteQuery, byte[] bytesResponse) {
            JsonClientQueryResponse jsonClientQueryResponse;
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(new ByteArrayInputStream(bytesResponse)));
            try {
                jsonClientQueryResponse = new JsonClientQueryResponse((JsonObject)this.mapper.fromJson(reader, JsonObject.class));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            reader.close();
            return jsonClientQueryResponse;
        }
    }
    ,
    DEFAULT(MediaType.MATCH_ALL){

        @Override
        byte[] serializeQueryRequest(RemoteQuery remoteQuery, QueryRequest queryRequest) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return ProtobufUtil.toByteArray((ImmutableSerializationContext)serCtx, (Object)queryRequest);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            Marshaller marshaller = remoteQuery.getCache().getRemoteCacheManager().getMarshaller();
            try {
                return marshaller.objectToByteBuffer((Object)queryRequest);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new HotRodClientException(e);
            }
        }

        QueryResponse readQueryResponse(Marshaller marshaller, RemoteQuery remoteQuery, byte[] bytesResponse) {
            SerializationContext serCtx = remoteQuery.getSerializationContext();
            if (serCtx != null) {
                try {
                    return (QueryResponse)ProtobufUtil.fromByteArray((ImmutableSerializationContext)serCtx, (byte[])bytesResponse, QueryResponse.class);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
            try {
                return (QueryResponse)marshaller.objectFromByteBuffer(bytesResponse);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new HotRodClientException(e);
            }
        }
    };

    private final MediaType mediaType;

    private QuerySerializer(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return this.mediaType.getTypeSubtype();
    }

    static QuerySerializer findByMediaType(MediaType mediaType) {
        return mediaType != null && mediaType.match(MediaType.APPLICATION_JSON) ? JSON : DEFAULT;
    }

    abstract byte[] serializeQueryRequest(RemoteQuery var1, QueryRequest var2);

    abstract BaseQueryResponse readQueryResponse(Marshaller var1, RemoteQuery var2, byte[] var3);
}

