/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class RecoveryIterator {
    private static final Log log = LogFactory.getLog(RecoveryIterator.class);
    private static final Xid[] NOTHING = new Xid[0];
    private final Set<Xid> uniqueFilter = Collections.synchronizedSet(new HashSet());
    private final BlockingDeque<Xid> inDoubtTransactions = new LinkedBlockingDeque<Xid>();
    private final CompletionStage<Void> remoteRequest;

    RecoveryIterator(Collection<Xid> localTransactions, CompletionStage<Collection<Xid>> remoteRequest) {
        this.add(localTransactions);
        this.remoteRequest = remoteRequest.thenAccept(this::add);
    }

    public Xid[] next() {
        if (this.inDoubtTransactions.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("RecoveryIterator.next() = []");
            }
            return NOTHING;
        }
        ArrayList txs = new ArrayList(this.inDoubtTransactions.size());
        this.inDoubtTransactions.drainTo(txs);
        if (log.isTraceEnabled()) {
            log.tracef("RecoveryIterator.next() = %s", txs);
        }
        return txs.toArray(NOTHING);
    }

    public void finish(long timeout) {
        block2: {
            try {
                this.remoteRequest.toCompletableFuture().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Exception while waiting for prepared transaction from server.", e);
            }
        }
    }

    private void add(Collection<Xid> transactions) {
        for (Xid xid : transactions) {
            if (!this.uniqueFilter.add(xid)) continue;
            if (log.isTraceEnabled()) {
                log.tracef("RecoveryIterator new xid=%s", xid);
            }
            this.inDoubtTransactions.add(xid);
        }
    }
}

