/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import com.google.errorprone.annotations.Immutable;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

@Immutable
public class GetKeyMultimapOperation<V>
extends AbstractMultimapKeyOperation<Collection<V>> {
    private int size;
    private Collection<V> result;

    public GetKeyMultimapOperation(InternalRemoteCache<?, ?> remoteCache, byte[] keyBytes, boolean supportsDuplicates) {
        super(remoteCache, keyBytes, supportsDuplicates);
    }

    @Override
    public Collection<V> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (HotRodConstants.isNotExist(status)) {
            return Collections.emptySet();
        }
        if (this.result == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = this.supportsDuplicates ? new ArrayList(this.size) : new HashSet(this.size);
            decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object value = unmarshaller.readValue(buf);
            this.result.add(value);
            decoder.checkpoint();
        }
        return this.result;
    }

    @Override
    public short requestOpCode() {
        return 103;
    }

    @Override
    public short responseOpCode() {
        return 104;
    }

    @Override
    public void reset() {
        this.result = null;
    }
}

