/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import com.google.errorprone.annotations.Immutable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.ContainsValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.GetKeyWithMetadataMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.MultimapOperationsFactory;
import org.infinispan.client.hotrod.impl.multimap.operations.PutKeyValueMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveEntryMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.RemoveKeyMultimapOperation;
import org.infinispan.client.hotrod.impl.multimap.operations.SizeMultimapOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

@Immutable
public class DefaultMultimapOperationsFactory
implements MultimapOperationsFactory {
    private final InternalRemoteCache<?, ?> remoteCache;
    private final Marshaller marshaller;
    private final BufferSizePredictor keySizePredictor;
    private final BufferSizePredictor valueSizePredictor;

    public DefaultMultimapOperationsFactory(InternalRemoteCache<?, ?> remoteCache, Marshaller marshaller, BufferSizePredictor keySizePredictor, BufferSizePredictor valueSizePredictor) {
        this.remoteCache = remoteCache;
        this.marshaller = marshaller;
        this.keySizePredictor = keySizePredictor;
        this.valueSizePredictor = valueSizePredictor;
    }

    @Override
    public <K, V> HotRodOperation<Collection<V>> newGetKeyMultimapOperation(K key, boolean supportsDuplicates) {
        return new GetKeyMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), supportsDuplicates);
    }

    @Override
    public <K, V> HotRodOperation<MetadataCollection<V>> newGetKeyWithMetadataMultimapOperation(K key, boolean supportsDuplicates) {
        return new GetKeyWithMetadataMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), supportsDuplicates);
    }

    @Override
    public <K, V> HotRodOperation<Void> newPutKeyValueOperation(K key, V value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, boolean supportsDuplicates) {
        return new PutKeyValueMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor), lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, supportsDuplicates);
    }

    @Override
    public <K> HotRodOperation<Boolean> newRemoveKeyOperation(K key, boolean supportsDuplicates) {
        return new RemoveKeyMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), supportsDuplicates);
    }

    @Override
    public <K, V> HotRodOperation<Boolean> newRemoveEntryOperation(K key, V value, boolean supportsDuplicates) {
        return new RemoveEntryMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor), supportsDuplicates);
    }

    @Override
    public <K, V> HotRodOperation<Boolean> newContainsEntryOperation(K key, V value, boolean supportsDuplicates) {
        return new ContainsEntryMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), MarshallerUtil.obj2bytes(this.marshaller, value, this.valueSizePredictor), supportsDuplicates);
    }

    @Override
    public <K> HotRodOperation<Boolean> newContainsKeyOperation(K key, boolean supportsDuplicates) {
        return new ContainsKeyMultimapOperation(this.remoteCache, MarshallerUtil.obj2bytes(this.marshaller, key, this.keySizePredictor), supportsDuplicates);
    }

    @Override
    public HotRodOperation<Boolean> newContainsValueOperation(byte[] value, boolean supportsDuplicates) {
        return new ContainsValueMultimapOperation(this.remoteCache, value, -1L, TimeUnit.MILLISECONDS, -1L, TimeUnit.MILLISECONDS, supportsDuplicates);
    }

    @Override
    public HotRodOperation<Long> newSizeOperation(boolean supportsDuplicates) {
        return new SizeMultimapOperation(this.remoteCache, supportsDuplicates);
    }
}

