/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.exceptions;

public class HotRodClientException
extends RuntimeException {
    private final long messageId;
    private final int errorStatusCode;

    public HotRodClientException() {
        this.messageId = -1L;
        this.errorStatusCode = -1;
    }

    public HotRodClientException(String message) {
        super(message);
        this.messageId = -1L;
        this.errorStatusCode = -1;
    }

    public HotRodClientException(Throwable cause) {
        super(cause);
        this.messageId = -1L;
        this.errorStatusCode = -1;
    }

    public HotRodClientException(String message, Throwable cause) {
        super(message, cause);
        this.messageId = -1L;
        this.errorStatusCode = -1;
    }

    public HotRodClientException(String remoteMessage, long messageId, int errorStatusCode) {
        super(remoteMessage);
        this.messageId = messageId;
        this.errorStatusCode = errorStatusCode;
    }

    @Override
    public String toString() {
        String message;
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(":");
        if (this.messageId != -1L) {
            sb.append("Request for messageId=").append(this.messageId);
        }
        if (this.errorStatusCode != -1) {
            sb.append(" returned ").append(this.toErrorMsg(this.errorStatusCode));
        }
        if ((message = this.getLocalizedMessage()) != null) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }

    private String toErrorMsg(int errorStatusCode) {
        return String.format("server error (status=0x%x)", errorStatusCode);
    }

    public boolean isServerError() {
        return this.errorStatusCode != -1;
    }
}

