/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.api.Experimental;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.schema.Schema;

@Experimental
public interface RemoteSchemasAdmin {
    default public Optional<Schema> get(String schemaName) {
        return this.getAsync(schemaName).toCompletableFuture().join();
    }

    public CompletionStage<Optional<Schema>> getAsync(String var1);

    default public Optional<String> retrieveError(String schemaName) {
        return this.retrieveErrorAsync(schemaName).toCompletableFuture().join();
    }

    public CompletionStage<Optional<String>> retrieveErrorAsync(String var1);

    default public SchemaErrors retrieveAllSchemaErrors() {
        return this.retrieveAllSchemaErrorsAsync().toCompletableFuture().join();
    }

    public CompletionStage<SchemaErrors> retrieveAllSchemaErrorsAsync();

    default public SchemaOpResult create(Schema schema) {
        return this.createAsync(schema).toCompletableFuture().join();
    }

    public CompletionStage<SchemaOpResult> createAsync(Schema var1);

    default public Map<String, SchemaOpResult> create(FileDescriptorSource fileDescriptorSource) {
        return this.createAsync(fileDescriptorSource).toCompletableFuture().join();
    }

    public CompletionStage<Map<String, SchemaOpResult>> createAsync(FileDescriptorSource var1);

    default public SchemaOpResult update(Schema schema) {
        return this.update(schema, false);
    }

    default public SchemaOpResult update(Schema schema, boolean force) {
        return this.updateAsync(schema, force).toCompletableFuture().join();
    }

    default public CompletionStage<SchemaOpResult> updateAsync(Schema schema) {
        return this.updateAsync(schema, false);
    }

    public CompletionStage<SchemaOpResult> updateAsync(Schema var1, boolean var2);

    default public Map<String, SchemaOpResult> update(FileDescriptorSource fileDescriptorSource) {
        return this.updateAsync(fileDescriptorSource).toCompletableFuture().join();
    }

    public CompletionStage<Map<String, SchemaOpResult>> updateAsync(FileDescriptorSource var1);

    default public SchemaOpResult createOrUpdate(Schema schema) {
        return this.createOrUpdate(schema, false);
    }

    default public SchemaOpResult createOrUpdate(Schema schema, boolean force) {
        return this.createOrUpdateAsync(schema, force).toCompletableFuture().join();
    }

    default public CompletionStage<SchemaOpResult> createOrUpdateAsync(Schema schema) {
        return this.createOrUpdateAsync(schema, false);
    }

    public CompletionStage<SchemaOpResult> createOrUpdateAsync(Schema var1, boolean var2);

    default public Map<String, SchemaOpResult> createOrUpdate(FileDescriptorSource fileDescriptorSource) {
        return this.createOrUpdateAsync(fileDescriptorSource).toCompletableFuture().join();
    }

    public CompletionStage<Map<String, SchemaOpResult>> createOrUpdateAsync(FileDescriptorSource var1);

    default public SchemaOpResult remove(String schemaName) {
        return this.remove(schemaName, false);
    }

    default public SchemaOpResult remove(String schemaName, boolean force) {
        return this.removeAsync(schemaName, force).toCompletableFuture().join();
    }

    default public CompletionStage<SchemaOpResult> removeAsync(String schemaName) {
        return this.removeAsync(schemaName, false);
    }

    public CompletionStage<SchemaOpResult> removeAsync(String var1, boolean var2);

    default public boolean exists(String schemaName) {
        return this.existsAsync(schemaName).toCompletableFuture().join();
    }

    public CompletionStage<Boolean> existsAsync(String var1);

    public record SchemaErrors(Map<String, String> errors) {
        public static final String ERRORS_KEY_SUFFIX = ".errors";

        public SchemaErrors {
            errors = errors == null ? Map.of() : Map.copyOf(errors);
        }

        public String getError(String schemaName) {
            Objects.requireNonNull(schemaName);
            return this.errors.getOrDefault(schemaName + ERRORS_KEY_SUFFIX, "");
        }

        public boolean isEmpty() {
            return this.errors.isEmpty();
        }

        public List<SchemaError> allErrorsAsList() {
            return this.errors.entrySet().stream().map(e -> new SchemaError((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        }

        public Set<String> schemas() {
            return this.errors.keySet();
        }
    }

    public static class SchemaOpResult {
        SchemaOpResultType type = SchemaOpResultType.NONE;
        String error = "";

        public SchemaOpResult() {
        }

        public SchemaOpResult(SchemaOpResultType type, String error) {
            this.type = type;
            this.error = error;
        }

        public SchemaOpResult(SchemaOpResultType type) {
            this.type = type;
        }

        public static SchemaOpResult none() {
            return new SchemaOpResult();
        }

        public SchemaOpResultType getType() {
            return this.type;
        }

        public String getError() {
            return this.error;
        }

        public boolean hasError() {
            return !this.error.isEmpty();
        }
    }

    public static enum SchemaOpResultType {
        CREATED,
        UPDATED,
        DELETED,
        NONE,
        ERROR;


        public static SchemaOpResultType fromCode(char c) {
            if (c == 'c') {
                return CREATED;
            }
            if (c == 'u') {
                return UPDATED;
            }
            if (c == 'd') {
                return DELETED;
            }
            if (c == 'n') {
                return NONE;
            }
            return ERROR;
        }
    }

    public record SchemaError(String name, String error) {
    }
}

