/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.impl.transport.netty.ActivationHandler;
import org.infinispan.client.hotrod.impl.transport.netty.AuthHandler;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.impl.transport.netty.IdleStateHandlerNoUnvoid;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.impl.transport.netty.PingHandler;
import org.infinispan.client.hotrod.impl.transport.netty.SslHandshakeExceptionHandler;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.SaslUtils;
import org.infinispan.commons.util.Util;

class ChannelInitializer
extends io.netty.channel.ChannelInitializer<Channel> {
    private static final Log log = LogFactory.getLog(ChannelInitializer.class);
    private final Bootstrap bootstrap;
    private final SocketAddress unresolvedAddress;
    private final Configuration configuration;
    private final String hostNameToUse;
    private final SslContext sslContext;
    private final OperationDispatcher dispatcher;
    private final Consumer<ChannelPipeline> pipelineDecorator;
    private static final Provider[] SECURITY_PROVIDERS;

    ChannelInitializer(Bootstrap bootstrap, SocketAddress unresolvedAddress, Configuration configuration, String hostNameToUse, SslContext sslContext, OperationDispatcher dispatcher, Consumer<ChannelPipeline> pipelineDecorator) {
        this.bootstrap = bootstrap;
        this.unresolvedAddress = unresolvedAddress;
        this.configuration = configuration;
        this.hostNameToUse = hostNameToUse;
        this.sslContext = sslContext;
        this.dispatcher = dispatcher;
        this.pipelineDecorator = pipelineDecorator;
    }

    ChannelFuture createChannel() {
        return this.bootstrap.clone().connect();
    }

    protected void initChannel(Channel channel) throws Exception {
        AuthenticationConfiguration authentication;
        if (log.isTraceEnabled()) {
            log.tracef("Created channel %s", channel);
        }
        if (this.configuration.security().ssl().enabled()) {
            this.initSsl(channel);
        }
        if ((authentication = this.configuration.security().authentication()).enabled()) {
            this.initAuthentication(channel, authentication);
        } else {
            channel.pipeline().addLast("activation-handler", (ChannelHandler)ActivationHandler.INSTANCE);
        }
        channel.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandlerNoUnvoid(60, 30, 0));
        channel.pipeline().addLast("pingHandler", (ChannelHandler)new PingHandler());
        channel.pipeline().addLast("header-decoder", (ChannelHandler)new HeaderDecoder(this.configuration, this.dispatcher));
        this.pipelineDecorator.accept(channel.pipeline());
    }

    private void initSsl(Channel channel) {
        SslConfiguration ssl = this.configuration.security().ssl();
        SslHandler sslHandler = this.sslContext.newHandler(channel.alloc(), ssl.sniHostName(), -1);
        String sniHostName = this.hostNameToUse != null ? this.hostNameToUse : (ssl.sniHostName() != null ? ssl.sniHostName() : ((InetSocketAddress)this.unresolvedAddress).getHostString());
        SSLParameters sslParameters = sslHandler.engine().getSSLParameters();
        sslParameters.setServerNames(Collections.singletonList(new SNIHostName(sniHostName)));
        if (ssl.hostnameValidation()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        sslHandler.engine().setSSLParameters(sslParameters);
        channel.pipeline().addFirst(new ChannelHandler[]{sslHandler, SslHandshakeExceptionHandler.INSTANCE});
    }

    private void initAuthentication(Channel channel, AuthenticationConfiguration authentication) throws PrivilegedActionException, SaslException {
        SaslClientFactory scf = this.getSaslClientFactory(authentication);
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        Principal principal = sslHandler != null ? sslHandler.engine().getSession().getLocalPrincipal() : null;
        String authorizationId = principal != null ? principal.getName() : null;
        SaslClient saslClient = authentication.clientSubject() != null ? Subject.doAs(authentication.clientSubject(), () -> scf.createSaslClient(new String[]{authentication.saslMechanism()}, authorizationId, "hotrod", authentication.serverName(), authentication.saslProperties(), authentication.callbackHandler())) : scf.createSaslClient(new String[]{authentication.saslMechanism()}, authorizationId, "hotrod", authentication.serverName(), authentication.saslProperties(), authentication.callbackHandler());
        channel.pipeline().addLast("auth-handler", (ChannelHandler)new AuthHandler(authentication, saslClient));
    }

    private SaslClientFactory getSaslClientFactory(AuthenticationConfiguration configuration) {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to load SaslClientFactory implementation with mech=%s, props=%s", configuration.saslMechanism(), configuration.saslProperties());
        }
        Collection clientFactories = SaslUtils.getSaslClientFactories((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Provider[])SECURITY_PROVIDERS, (boolean)true);
        for (SaslClientFactory saslFactory : clientFactories) {
            try {
                String[] saslFactoryMechs;
                for (String supportedMech : saslFactoryMechs = saslFactory.getMechanismNames(configuration.saslProperties())) {
                    if (!supportedMech.equals(configuration.saslMechanism())) continue;
                    if (log.isTraceEnabled()) {
                        log.tracef("Loaded SaslClientFactory: %s", saslFactory.getClass().getName());
                    }
                    return saslFactory;
                }
            }
            catch (Throwable t) {
                log.tracef("Error while trying to obtain mechanism names supported by SaslClientFactory: %s", saslFactory.getClass().getName());
            }
        }
        throw new IllegalStateException("SaslClientFactory implementation not found");
    }

    static {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (String name : Arrays.asList("org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider", "org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider", "org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider", "org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider", "org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider", "org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider", "org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider")) {
            Provider provider = (Provider)Util.getInstance((String)name, (ClassLoader)RemoteCacheManager.class.getClassLoader());
            providers.add(provider);
        }
        SECURITY_PROVIDERS = providers.toArray(new Provider[0]);
    }
}

