/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.AbstractCacheOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class GetAllOperation<K, V>
extends AbstractCacheOperation<Map<K, V>> {
    private Map<K, V> result;
    private int size = -1;
    protected final Set<byte[]> keys;

    public GetAllOperation(InternalRemoteCache<?, ?> remoteCache, Set<byte[]> keys) {
        super(remoteCache);
        this.keys = keys;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ByteBufUtil.writeVInt(buf, this.keys.size());
        for (byte[] key : this.keys) {
            ByteBufUtil.writeArray(buf, key);
        }
    }

    @Override
    public void reset() {
        this.size = -1;
        this.result = null;
    }

    @Override
    public Map<K, V> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        if (this.size < 0) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = new HashMap(this.size);
            decoder.checkpoint();
        }
        while (this.result.size() < this.size) {
            Object key = unmarshaller.readKey(buf);
            Object value = unmarshaller.readValue(buf);
            this.result.put(key, value);
            decoder.checkpoint();
        }
        return this.result;
    }

    @Override
    public void handleStatsCompletion(ClientStatistics statistics, long startTime, short status, Map<K, V> responseValue) {
        statistics.dataRead(true, startTime, responseValue.size());
        statistics.dataRead(false, startTime, this.keys.size() - responseValue.size());
    }

    @Override
    public short requestOpCode() {
        return 47;
    }

    @Override
    public short responseOpCode() {
        return 48;
    }
}

