/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.counter.impl.CounterOperationFactory;
import org.infinispan.client.hotrod.counter.impl.NotificationManager;
import org.infinispan.client.hotrod.counter.impl.StrongCounterImpl;
import org.infinispan.client.hotrod.counter.impl.WeakCounterImpl;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterException;

public class RemoteCounterManager
implements CounterManager {
    private final Map<String, Object> counters = new ConcurrentHashMap<String, Object>();
    private CounterOperationFactory factory;
    private OperationDispatcher dispatcher;
    private NotificationManager notificationManager;

    public void start(OperationDispatcher dispatcher, ClientListenerNotifier listenerNotifier) {
        this.factory = new CounterOperationFactory();
        this.dispatcher = dispatcher;
        this.notificationManager = new NotificationManager(listenerNotifier, this.factory, dispatcher);
        dispatcher.addCacheTopologyInfoIfAbsent("org.infinispan.COUNTER");
    }

    public StrongCounter getStrongCounter(String name) {
        return this.getOrCreateCounter(name, StrongCounter.class, this::createStrongCounter, () -> Log.HOTROD.invalidCounterType("Strong", "Weak"));
    }

    public WeakCounter getWeakCounter(String name) {
        return this.getOrCreateCounter(name, WeakCounter.class, this::createWeakCounter, () -> Log.HOTROD.invalidCounterType("Weak", "Strong"));
    }

    public boolean defineCounter(String name, CounterConfiguration configuration) {
        return Util.await(this.dispatcher.execute(this.factory.newDefineCounterOperation(name, configuration)));
    }

    public void undefineCounter(String name) {
    }

    public boolean isDefined(String name) {
        return Util.await(this.dispatcher.execute(this.factory.newIsDefinedOperation(name)));
    }

    public CounterConfiguration getConfiguration(String counterName) {
        return Util.await(this.dispatcher.execute(this.factory.newGetConfigurationOperation(counterName)));
    }

    public void remove(String counterName) {
        Util.await(this.dispatcher.execute(this.factory.newRemoveOperation(counterName, true)));
    }

    public Collection<String> getCounterNames() {
        return Util.await(this.dispatcher.execute(this.factory.newGetCounterNamesOperation()));
    }

    public void stop() {
        if (this.notificationManager != null) {
            this.notificationManager.stop();
        }
    }

    private <T> T getOrCreateCounter(String name, Class<T> tClass, Function<String, T> createFunction, Supplier<CounterException> invalidCounter) {
        Object counter = this.counters.computeIfAbsent(name, createFunction);
        if (!tClass.isInstance(counter)) {
            throw invalidCounter.get();
        }
        return tClass.cast(counter);
    }

    private void assertWeakCounter(CounterConfiguration configuration) {
        if (configuration.type() != CounterType.WEAK) {
            throw Log.HOTROD.invalidCounterType("Weak", "Strong");
        }
    }

    private WeakCounter createWeakCounter(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.HOTROD.undefinedCounter(counterName);
        }
        this.assertWeakCounter(configuration);
        return new WeakCounterImpl(counterName, configuration, this.factory, this.dispatcher, this.notificationManager);
    }

    private StrongCounter createStrongCounter(String counterName) {
        CounterConfiguration configuration = this.getConfiguration(counterName);
        if (configuration == null) {
            throw Log.HOTROD.undefinedCounter(counterName);
        }
        this.assertStrongCounter(configuration);
        return new StrongCounterImpl(counterName, configuration, this.factory, this.dispatcher, this.notificationManager);
    }

    private void assertStrongCounter(CounterConfiguration configuration) {
        if (configuration.type() == CounterType.WEAK) {
            throw Log.HOTROD.invalidCounterType("Strong", "Weak");
        }
    }
}

