/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.near.NearCache;

final class BoundedConcurrentMapNearCache<K, V>
implements NearCache<K, V> {
    private final ConcurrentMap<K, MetadataValue<V>> map;
    private final Cache<K, MetadataValue<V>> cache;

    private BoundedConcurrentMapNearCache(Cache<K, MetadataValue<V>> cache) {
        this.cache = cache;
        this.map = cache.asMap();
    }

    public static <K, V> NearCache<K, V> create(NearCacheConfiguration config, BiConsumer<? super K, ? super MetadataValue<V>> removedConsumer) {
        Cache cache = Caffeine.newBuilder().maximumSize((long)config.maxEntries()).executor(Runnable::run).removalListener((key, value, cause) -> {
            if (cause != RemovalCause.REPLACED) {
                removedConsumer.accept((Object)key, (Object)value);
            }
        }).build();
        return new BoundedConcurrentMapNearCache<K, V>(cache);
    }

    @Override
    public boolean putIfAbsent(K key, MetadataValue<V> value) {
        return this.map.putIfAbsent(key, value) == null;
    }

    @Override
    public boolean replace(K key, MetadataValue<V> prevValue, MetadataValue<V> newValue) {
        return this.map.replace(key, prevValue, newValue);
    }

    @Override
    public boolean remove(K key) {
        return this.map.remove(key) != null;
    }

    @Override
    public boolean remove(K key, MetadataValue<V> value) {
        return this.map.remove(key, value);
    }

    @Override
    public MetadataValue<V> get(K key) {
        return (MetadataValue)this.map.get(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        this.cache.cleanUp();
        return this.map.size();
    }

    @Override
    public Iterator<Map.Entry<K, MetadataValue<V>>> iterator() {
        return this.map.entrySet().iterator();
    }
}

