/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.impl;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.util.Properties;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.Util;

public class KubernetesContext
extends ContextImpl {
    private final KubernetesClient kubernetesClient;

    public KubernetesContext(Properties defaults, KubernetesClient client) {
        super(defaults);
        this.kubernetesClient = client;
    }

    public KubernetesContext(Properties defaults) {
        this(defaults, new KubernetesClientBuilder().build());
    }

    public static KubernetesClient getClient(ContextAwareCommandInvocation invocation) {
        if (invocation.getContext() instanceof KubernetesContext) {
            return ((KubernetesContext)invocation.getContext()).kubernetesClient;
        }
        throw Messages.MSG.noKubernetes();
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    @Override
    public void disconnect() {
        Util.close((AutoCloseable)this.kubernetesClient);
        super.disconnect();
    }
}

