/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.user;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.cli.logging.Messages;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;

public class UserTool {
    public static final Supplier<Provider[]> PROVIDERS = () -> new Provider[]{WildFlyElytronPasswordProvider.getInstance()};
    public static final String DEFAULT_USERS_PROPERTIES_FILE = "users.properties";
    public static final String DEFAULT_GROUPS_PROPERTIES_FILE = "groups.properties";
    public static final String DEFAULT_REALM_NAME = "default";
    public static final String DEFAULT_SERVER_ROOT = "server";
    private static final String COMMENT_PREFIX1 = "#";
    private static final String COMMENT_PREFIX2 = "!";
    private static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    private static final String COMMENT_SUFFIX = "$";
    private static final String ALGORITHM_COMMENT_PREFIX = "$ALGORITHM=";
    public static final List<String> DEFAULT_ALGORITHMS = Collections.unmodifiableList(Arrays.asList("scram-sha-1", "scram-sha-256", "scram-sha-384", "scram-sha-512", "digest-md5", "digest-sha", "digest-sha-256", "digest-sha-384", "digest-sha-512"));
    private final Path serverRoot;
    private final Path usersFile;
    private final Path groupsFile;
    private Properties users = new Properties();
    private Properties groups = new Properties();
    private String realm = null;
    private Encryption encryption = Encryption.DEFAULT;

    public UserTool(String serverRoot) {
        this(serverRoot, DEFAULT_USERS_PROPERTIES_FILE, DEFAULT_GROUPS_PROPERTIES_FILE);
    }

    public UserTool(String serverRoot, String usersFile, String groupsFile) {
        this(serverRoot != null ? Paths.get(serverRoot, new String[0]) : null, usersFile != null ? Paths.get(usersFile, new String[0]) : null, groupsFile != null ? Paths.get(groupsFile, new String[0]) : null);
    }

    public UserTool(Path serverRoot, Path usersFile, Path groupsFile) {
        if (serverRoot != null && serverRoot.isAbsolute()) {
            this.serverRoot = serverRoot;
        } else {
            String serverHome = System.getProperty("infinispan.server.home.path");
            Path serverHomePath = serverHome == null ? Paths.get("", new String[0]) : Paths.get(serverHome, new String[0]);
            this.serverRoot = serverRoot == null ? serverHomePath.resolve(DEFAULT_SERVER_ROOT) : serverHomePath.resolve(serverRoot);
        }
        this.usersFile = usersFile == null ? this.serverRoot.resolve("conf").resolve(DEFAULT_USERS_PROPERTIES_FILE) : (usersFile.isAbsolute() ? usersFile : this.serverRoot.resolve("conf").resolve(usersFile));
        this.groupsFile = groupsFile == null ? this.serverRoot.resolve("conf").resolve(DEFAULT_GROUPS_PROPERTIES_FILE) : (groupsFile.isAbsolute() ? groupsFile : this.serverRoot.resolve("conf").resolve(groupsFile));
        this.load();
    }

    public void reload() {
        this.realm = null;
        this.encryption = Encryption.DEFAULT;
        this.load();
    }

    private void load() {
        BufferedReader reader;
        if (Files.exists(this.usersFile, new LinkOption[0])) {
            try {
                reader = Files.newBufferedReader(this.usersFile, StandardCharsets.UTF_8);
                try {
                    String currentLine;
                    while ((currentLine = reader.readLine()) != null) {
                        String trimmed = currentLine.trim();
                        if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(REALM_COMMENT_PREFIX)) {
                            int start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length();
                            int end = trimmed.indexOf(COMMENT_SUFFIX, start);
                            if (end <= -1) continue;
                            this.realm = trimmed.substring(start, end);
                            continue;
                        }
                        if (trimmed.startsWith(COMMENT_PREFIX1) && trimmed.contains(ALGORITHM_COMMENT_PREFIX)) {
                            int start = trimmed.indexOf(ALGORITHM_COMMENT_PREFIX) + ALGORITHM_COMMENT_PREFIX.length();
                            int end = trimmed.indexOf(COMMENT_SUFFIX, start);
                            if (end <= -1) continue;
                            this.encryption = Encryption.valueOf(trimmed.substring(start, end).toUpperCase());
                            continue;
                        }
                        if (trimmed.startsWith(COMMENT_PREFIX1) || trimmed.startsWith(COMMENT_PREFIX2)) continue;
                        String username = null;
                        StringBuilder builder = new StringBuilder();
                        CodePointIterator it = CodePointIterator.ofString((String)trimmed);
                        while (it.hasNext()) {
                            int cp = it.next();
                            if (cp == 92 && it.hasNext()) {
                                int marker = it.next();
                                if (marker != 117) {
                                    builder.appendCodePoint(marker);
                                    continue;
                                }
                                StringBuilder hex = new StringBuilder();
                                try {
                                    hex.appendCodePoint(it.next());
                                    hex.appendCodePoint(it.next());
                                    hex.appendCodePoint(it.next());
                                    hex.appendCodePoint(it.next());
                                    builder.appendCodePoint((char)Integer.parseInt(hex.toString(), 16));
                                    continue;
                                }
                                catch (NoSuchElementException nsee) {
                                    throw Messages.MSG.invalidUnicodeSequence(hex.toString(), nsee);
                                }
                            }
                            if (username == null && (cp == 61 || cp == 58)) {
                                username = builder.toString().trim();
                                builder = new StringBuilder();
                                continue;
                            }
                            builder.appendCodePoint(cp);
                        }
                        if (username == null) continue;
                        this.users.setProperty(username, builder.toString());
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                throw Messages.MSG.userToolIOError(this.usersFile, e);
            }
        }
        if (Files.exists(this.groupsFile, new LinkOption[0])) {
            try {
                reader = Files.newBufferedReader(this.groupsFile);
                try {
                    this.groups.load(reader);
                }
                finally {
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
            }
            catch (IOException e) {
                throw Messages.MSG.userToolIOError(this.groupsFile, e);
            }
        }
    }

    private void store() {
        this.store(this.realm, this.encryption);
    }

    private void store(String realm, Encryption encryption) {
        BufferedWriter writer;
        encryption = this.checkEncryption(encryption);
        if (realm == null) {
            realm = this.realm;
        }
        try {
            writer = Files.newBufferedWriter(this.usersFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                this.users.store(writer, REALM_COMMENT_PREFIX + realm + "$\n$ALGORITHM=" + (encryption == Encryption.CLEAR ? "clear" : "encrypted") + COMMENT_SUFFIX);
            }
            finally {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException e) {
            throw Messages.MSG.userToolIOError(this.usersFile, e);
        }
        try {
            writer = Files.newBufferedWriter(this.groupsFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                this.groups.store(writer, null);
            }
            finally {
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
        }
        catch (IOException e) {
            throw Messages.MSG.userToolIOError(this.groupsFile, e);
        }
    }

    private Encryption checkEncryption(Encryption encryption) {
        if (encryption == Encryption.DEFAULT) {
            return this.encryption;
        }
        if (this.encryption == Encryption.DEFAULT) {
            return encryption;
        }
        if (this.encryption == encryption) {
            return encryption;
        }
        throw Messages.MSG.userToolIncompatibleEncrypyion(encryption, this.encryption);
    }

    public String checkRealm(String realm) {
        if (realm == null) {
            return this.realm == null ? DEFAULT_REALM_NAME : this.realm;
        }
        if (this.realm == null || this.realm.equals(realm)) {
            return realm;
        }
        throw Messages.MSG.userToolWrongRealm(realm, this.realm);
    }

    public void createUser(String username, String password, String realm, Encryption encryption, List<String> userGroups, List<String> algorithms) {
        if (this.users.containsKey(username)) {
            throw Messages.MSG.userToolUserExists(username);
        }
        realm = this.checkRealm(realm);
        this.users.put(username, Encryption.CLEAR.equals((Object)encryption) ? password : this.encryptPassword(username, realm, password, algorithms));
        this.groups.put(username, userGroups != null ? String.join((CharSequence)",", userGroups) : "");
        this.store(realm, encryption);
    }

    public String describeUser(String username) {
        if (this.users.containsKey(username)) {
            String[] userGroups = this.groups.containsKey(username) ? this.groups.getProperty(username).trim().split("\\s*,\\s*") : new String[]{};
            return Messages.MSG.userDescribe(username, this.realm, userGroups);
        }
        throw Messages.MSG.userToolNoSuchUser(username);
    }

    public void removeUser(String username) {
        this.users.remove(username);
        this.groups.remove(username);
        this.store();
    }

    public void modifyUser(String username, String password, String realm, Encryption encryption, List<String> userGroups, List<String> algorithms) {
        if (!this.users.containsKey(username)) {
            throw Messages.MSG.userToolNoSuchUser(username);
        }
        realm = this.checkRealm(realm);
        if (password != null) {
            this.users.put(username, Encryption.CLEAR.equals((Object)encryption) ? password : this.encryptPassword(username, realm, password, algorithms));
        }
        if (userGroups != null) {
            this.groups.put(username, String.join((CharSequence)",", userGroups));
        }
        this.store(realm, encryption);
    }

    public void encryptAll(List<String> algorithms) {
        if (this.encryption == Encryption.CLEAR) {
            this.users.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(u, p) -> this.encryptPassword((String)u, this.realm, (String)p, algorithms)));
            this.encryption = Encryption.ENCRYPTED;
            this.store(this.realm, Encryption.ENCRYPTED);
        }
    }

    private String encryptPassword(String username, String realm, String password, List<String> algorithms) {
        try {
            if (algorithms == null) {
                algorithms = DEFAULT_ALGORITHMS;
            }
            StringBuilder sb = new StringBuilder();
            for (String algorithm : algorithms) {
                DigestPasswordAlgorithmSpec spec;
                PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithm, (Provider)WildFlyElytronPasswordProvider.getInstance());
                sb.append(algorithm);
                sb.append(":");
                switch (algorithm) {
                    case "scram-sha-1": 
                    case "scram-sha-256": 
                    case "scram-sha-384": 
                    case "scram-sha-512": {
                        spec = new IteratedSaltedPasswordAlgorithmSpec(20000, UserTool.salt(12));
                        break;
                    }
                    case "digest-md5": 
                    case "digest-sha": 
                    case "digest-sha-256": 
                    case "digest-sha-384": 
                    case "digest-sha-512": {
                        spec = new DigestPasswordAlgorithmSpec(username, realm);
                        break;
                    }
                    default: {
                        throw Messages.MSG.userToolUnknownAlgorithm(algorithm);
                    }
                }
                Password encrypted = passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(password.toCharArray(), (AlgorithmParameterSpec)spec));
                byte[] encoded = BasicPasswordSpecEncoding.encode((Password)encrypted, PROVIDERS);
                sb.append(ByteIterator.ofBytes((byte[])encoded).base64Encode().drainToString());
                sb.append(";");
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] salt(int size) {
        byte[] salt = new byte[size];
        ThreadLocalRandom.current().nextBytes(salt);
        return salt;
    }

    public List<String> listUsers() {
        ArrayList<String> userList = new ArrayList<String>(this.users.stringPropertyNames());
        Collections.sort(userList);
        return userList;
    }

    public List<String> listGroups() {
        return this.groups.values().stream().map(o -> (String)o).map(s -> s.split("\\s*,\\s*")).flatMap(a -> Arrays.stream(a)).filter(g -> !g.isEmpty()).sorted().distinct().collect(Collectors.toList());
    }

    public static enum Encryption {
        DEFAULT,
        ENCRYPTED,
        CLEAR;


        public static Encryption valueOf(boolean plainText) {
            return plainText ? CLEAR : DEFAULT;
        }
    }
}

