/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

public class Annotateds {
    private static final char SEPERATOR = ';';

    private Annotateds() {
    }

    public static <X> String createTypeId(AnnotatedType<X> annotatedType) {
        return Annotateds.createTypeId(annotatedType.getJavaClass(), annotatedType.getAnnotations(), annotatedType.getMethods(), annotatedType.getFields(), annotatedType.getConstructors());
    }

    public static <X> String createTypeId(Class<X> clazz, Collection<Annotation> annotations, Collection<AnnotatedMethod<? super X>> methods, Collection<AnnotatedField<? super X>> fields, Collection<AnnotatedConstructor<X>> constructors) {
        StringBuilder builder = new StringBuilder();
        builder.append(clazz.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        builder.append("{");
        ArrayList<AnnotatedField<? super X>> sortedFields = new ArrayList<AnnotatedField<? super X>>();
        sortedFields.addAll(fields);
        Collections.sort(sortedFields, AnnotatedFieldComparator.instance());
        for (AnnotatedField annotatedField : sortedFields) {
            if (annotatedField.getAnnotations().isEmpty()) continue;
            builder.append(Annotateds.createFieldId(annotatedField));
            builder.append(';');
        }
        ArrayList<AnnotatedMethod<? super X>> sortedMethods = new ArrayList<AnnotatedMethod<? super X>>();
        sortedMethods.addAll(methods);
        Collections.sort(sortedMethods, AnnotatedMethodComparator.instance());
        for (AnnotatedMethod annotatedMethod : sortedMethods) {
            if (annotatedMethod.getAnnotations().isEmpty() && !Annotateds.hasMethodParameters(annotatedMethod)) continue;
            builder.append(Annotateds.createCallableId(annotatedMethod));
            builder.append(';');
        }
        ArrayList<AnnotatedConstructor<X>> arrayList = new ArrayList<AnnotatedConstructor<X>>();
        arrayList.addAll(constructors);
        Collections.sort(arrayList, AnnotatedConstructorComparator.instance());
        for (AnnotatedConstructor annotatedConstructor : arrayList) {
            if (annotatedConstructor.getAnnotations().isEmpty() && !Annotateds.hasMethodParameters(annotatedConstructor)) continue;
            builder.append(Annotateds.createCallableId(annotatedConstructor));
            builder.append(';');
        }
        builder.append("}");
        return builder.toString();
    }

    public static <X> String createFieldId(AnnotatedField<X> field) {
        return Annotateds.createFieldId(field.getJavaMember(), field.getAnnotations());
    }

    public static <X> String createFieldId(Field field, Collection<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        builder.append(field.getDeclaringClass().getName());
        builder.append('.');
        builder.append(field.getName());
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    public static <X> String createCallableId(AnnotatedCallable<X> method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getJavaMember().getDeclaringClass().getName());
        builder.append('.');
        builder.append(method.getJavaMember().getName());
        builder.append(Annotateds.createAnnotationCollectionId(method.getAnnotations()));
        builder.append(Annotateds.createParameterListId(method.getParameters()));
        return builder.toString();
    }

    public static <X> String createParameterListId(List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            AnnotatedParameter<X> ap = parameters.get(i);
            builder.append(Annotateds.createParameterId(ap));
            if (i + 1 == parameters.size()) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    public static <X> String createParameterId(AnnotatedParameter<X> annotatedParameter) {
        return Annotateds.createParameterId(annotatedParameter.getBaseType(), annotatedParameter.getAnnotations());
    }

    public static <X> String createParameterId(Type type, Set<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        if (type instanceof Class) {
            Class c = (Class)type;
            builder.append(c.getName());
        } else {
            builder.append(type.toString());
        }
        builder.append(Annotateds.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    private static <X> boolean hasMethodParameters(AnnotatedCallable<X> callable) {
        for (AnnotatedParameter parameter : callable.getParameters()) {
            if (parameter.getAnnotations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static String createAnnotationCollectionId(Collection<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.size());
        annotationList.addAll(annotations);
        Collections.sort(annotationList, AnnotationComparator.INSTANCE);
        for (Annotation a : annotationList) {
            builder.append('@');
            builder.append(a.annotationType().getName());
            builder.append('(');
            Method[] declaredMethods = a.annotationType().getDeclaredMethods();
            ArrayList<Method> methods = new ArrayList<Method>(declaredMethods.length);
            for (Method m : declaredMethods) {
                methods.add(m);
            }
            Collections.sort(methods, MethodComparator.INSTANCE);
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                try {
                    Object value = method.invoke((Object)a, new Object[0]);
                    builder.append(method.getName());
                    builder.append('=');
                    builder.append(value.toString());
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("NullPointerException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("IllegalArgumentException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("IllegalAccessException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("InvocationTargetException accessing annotation member, annotation:" + a.annotationType().getName() + " member: " + method.getName(), e);
                }
                if (i + 1 == methods.size()) continue;
                builder.append(',');
            }
            builder.append(')');
        }
        builder.append(']');
        return builder.toString();
    }

    private static class AnnotatedFieldComparator<T>
    implements Comparator<AnnotatedField<? super T>> {
        private AnnotatedFieldComparator() {
        }

        public static <T> Comparator<AnnotatedField<? super T>> instance() {
            return new AnnotatedFieldComparator<T>();
        }

        @Override
        public int compare(AnnotatedField<? super T> arg0, AnnotatedField<? super T> arg1) {
            if (arg0.getJavaMember().getName().equals(arg1.getJavaMember().getName())) {
                return arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            }
            return arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
        }
    }

    private static class AnnotatedMethodComparator<T>
    implements Comparator<AnnotatedMethod<? super T>> {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedMethodComparator() {
        }

        public static <T> Comparator<AnnotatedMethod<? super T>> instance() {
            return new AnnotatedMethodComparator<T>();
        }

        @Override
        public int compare(AnnotatedMethod<? super T> arg0, AnnotatedMethod<? super T> arg1) {
            int result = this.callableComparator.compare((AnnotatedCallable<? super T>)arg0, (AnnotatedCallable<? super T>)arg1);
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterCount(); ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    private static class AnnotatedConstructorComparator<T>
    implements Comparator<AnnotatedConstructor<? super T>> {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedConstructorComparator() {
        }

        public static <T> Comparator<AnnotatedConstructor<? super T>> instance() {
            return new AnnotatedConstructorComparator<T>();
        }

        @Override
        public int compare(AnnotatedConstructor<? super T> arg0, AnnotatedConstructor<? super T> arg1) {
            int result = this.callableComparator.compare((AnnotatedCallable<? super T>)arg0, (AnnotatedCallable<? super T>)arg1);
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterCount(); ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    private static class AnnotationComparator
    implements Comparator<Annotation> {
        public static final Comparator<Annotation> INSTANCE = new AnnotationComparator();

        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation arg0, Annotation arg1) {
            return arg0.annotationType().getName().compareTo(arg1.annotationType().getName());
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        public static final Comparator<Method> INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public int compare(Method arg0, Method arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    private static class AnnotatedCallableComparator<T>
    implements Comparator<AnnotatedCallable<? super T>> {
        private AnnotatedCallableComparator() {
        }

        @Override
        public int compare(AnnotatedCallable<? super T> arg0, AnnotatedCallable<? super T> arg1) {
            int result = arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getParameters().size() - arg1.getParameters().size();
            return result;
        }
    }
}

